/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.LaunchTaskRunner;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.LaunchTasksProviderFactory;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunState
implements RunProfileState {
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    private final String myLaunchConfigName;
    @NotNull
    private final Module myModule;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final ConsoleProvider myConsoleProvider;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProviderFactory myLaunchTasksProviderFactory;
    @Nullable
    private final ProcessHandler myPreviousSessionProcessHandler;

    public AndroidRunState(@NotNull ExecutionEnvironment env, @NotNull String launchConfigName, @NotNull Module module, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ConsoleProvider consoleProvider, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProviderFactory launchTasksProviderFactory, @Nullable ProcessHandler processHandler) {
        this.myEnv = env;
        this.myLaunchConfigName = launchConfigName;
        this.myModule = module;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myConsoleProvider = consoleProvider;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProviderFactory = launchTasksProviderFactory;
        this.myPreviousSessionProcessHandler = processHandler;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        ConsoleView console;
        ProcessHandler processHandler;
        LaunchTasksProvider launchTasksProvider;
        String applicationId;
        try {
            applicationId = this.myApplicationIdProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException("Unable to obtain application id", (Throwable)e);
        }
        AndroidModuleModel model = AndroidModuleModel.get(this.myModule);
        if (InstantRunSettings.isInstantRunEnabled() && InstantRunGradleUtils.getIrSupportStatus(model, null) == InstantRunGradleSupport.SUPPORTED) {
            assert (model != null);
            InstantRunBuildInfo info = InstantRunGradleUtils.getBuildInfo(model);
            if (info != null && !info.isCompatibleFormat()) {
                throw new ExecutionException("This version of Android Studio is incompatible with the Gradle Plugin used. Try disabling Instant Run (or updating either the IDE or the Gradle plugin to the latest version)");
            }
        }
        if ((launchTasksProvider = this.myLaunchTasksProviderFactory.get()).createsNewProcess()) {
            if (this.myPreviousSessionProcessHandler != null) {
                this.myPreviousSessionProcessHandler.detachProcess();
            }
            processHandler = new AndroidProcessHandler(applicationId, launchTasksProvider.monitorRemoteProcess());
            console = this.attachConsole(processHandler, executor);
        } else {
            assert (this.myPreviousSessionProcessHandler != null) : "No process handler from previous session, yet current tasks don't create one";
            processHandler = this.myPreviousSessionProcessHandler;
            console = null;
        }
        LaunchInfo launchInfo = new LaunchInfo(executor, runner, this.myEnv, this.myConsoleProvider);
        LaunchTaskRunner task = new LaunchTaskRunner(this.myModule.getProject(), this.myLaunchConfigName, launchInfo, processHandler, this.myDeviceFutures, launchTasksProvider);
        ProgressManager.getInstance().run((Task)task);
        return console == null ? null : new DefaultExecutionResult((ExecutionConsole)console, processHandler);
    }

    @NotNull
    public ConsoleView attachConsole(@NotNull ProcessHandler processHandler, @NotNull Executor executor) throws ExecutionException {
        return this.myConsoleProvider.createAndAttach((Disposable)this.myModule.getProject(), processHandler, executor);
    }
}

