/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Abi;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConnectedAndroidDevice
implements AndroidDevice {
    private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
    @NotNull
    private final IDevice myDevice;
    @Nullable
    private final String myAvdName;
    @Nullable
    private final DeviceNameRendererEx myDeviceNameRenderer;
    private volatile String myDeviceManufacturer;
    private volatile String myDeviceBuild;
    private volatile String myDeviceModel;

    public ConnectedAndroidDevice(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        this.myDevice = device;
        AvdInfo avdInfo = ConnectedAndroidDevice.getAvdInfo(device, avdInfos);
        this.myAvdName = avdInfo == null ? null : AvdManagerConnection.getAvdDisplayName(avdInfo);
        this.myDeviceNameRenderer = ConnectedAndroidDevice.getRendererExtension(device);
    }

    @Nullable
    private static AvdInfo getAvdInfo(@NotNull IDevice device, @Nullable List<AvdInfo> avdInfos) {
        if (avdInfos != null && device.isEmulator()) {
            for (AvdInfo info : avdInfos) {
                if (!info.getName().equals(device.getAvdName())) continue;
                return info;
            }
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean isVirtual() {
        return this.myDevice.isEmulator();
    }

    @Override
    @NotNull
    public AndroidVersion getVersion() {
        return this.myDevice.getVersion();
    }

    @Override
    public int getDensity() {
        return this.myDevice.getDensity();
    }

    @Override
    @NotNull
    public List<Abi> getAbis() {
        List abis = this.myDevice.getAbis();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String abi : abis) {
            Abi a = Abi.getEnum((String)abi);
            if (a == null) continue;
            builder.add((Object)a);
        }
        return builder.build();
    }

    @Override
    @NotNull
    public String getSerial() {
        String avdName;
        if (this.myDevice.isEmulator() && (avdName = this.myDevice.getAvdName()) != null) {
            return avdName;
        }
        return this.myDevice.getSerialNumber();
    }

    @Override
    public boolean supportsFeature(@NotNull IDevice.HardwareFeature feature) {
        return this.myDevice.supportsFeature(feature);
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myDeviceNameRenderer != null) {
            return this.myDeviceNameRenderer.getName(this.myDevice);
        }
        return this.myAvdName == null ? this.getDeviceName() : this.myAvdName;
    }

    @Override
    public boolean renderLabel(@NotNull SimpleColoredComponent renderer, boolean isCompatible, @Nullable String searchPrefix) {
        if (this.myDeviceNameRenderer != null) {
            this.myDeviceNameRenderer.render(this.myDevice, (ColoredTextContainer)renderer);
            return true;
        }
        renderer.setIcon(this.myDevice.isEmulator() ? AndroidIcons.Ddms.EmulatorDevice : AndroidIcons.Ddms.RealDevice);
        IDevice.DeviceState state = this.myDevice.getState();
        if (state != IDevice.DeviceState.ONLINE) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%1$s [%2$s", this.myDevice.getSerialNumber(), state));
            if (state == IDevice.DeviceState.UNAUTHORIZED) {
                buf.append(" - Press 'OK' in the 'Allow USB Debugging' dialog on your device");
            }
            buf.append("] ");
            renderer.append(buf.toString(), SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
            return true;
        }
        if (this.myDeviceManufacturer != null && this.myDeviceModel != null && this.myDeviceBuild != null) {
            SimpleTextAttributes attr = isCompatible ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            String name = this.getName();
            if (name.isEmpty()) {
                name = "Unknown";
            }
            SearchUtil.appendFragments((String)searchPrefix, (String)name, (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)renderer);
            String build = this.getDeviceBuild();
            if (!build.isEmpty()) {
                renderer.append(" (" + build + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            return true;
        }
        renderer.append("...");
        return false;
    }

    @NotNull
    private String getDeviceName() {
        StringBuilder name = new StringBuilder(20);
        name.append(this.getDeviceManufacturer());
        if (name.length() > 0) {
            name.append(' ');
        }
        name.append(this.getDeviceModel());
        return name.toString();
    }

    @Override
    public void prepareToRenderLabel() {
        assert (!this.isDispatchThread());
        this.getDeviceManufacturer();
        this.getDeviceModel();
        this.getDeviceBuild();
    }

    @NotNull
    private String getDeviceManufacturer() {
        if (this.myDeviceManufacturer == null) {
            assert (!this.isDispatchThread());
            this.myDeviceManufacturer = DevicePropertyUtil.getManufacturer(this.myDevice, "");
        }
        return this.myDeviceManufacturer;
    }

    @NotNull
    private String getDeviceModel() {
        if (this.myDeviceModel == null) {
            assert (!this.isDispatchThread());
            this.myDeviceModel = DevicePropertyUtil.getModel(this.myDevice, "");
        }
        return this.myDeviceModel;
    }

    @NotNull
    private String getDeviceBuild() {
        if (this.myDeviceBuild == null) {
            assert (!this.isDispatchThread());
            this.myDeviceBuild = DevicePropertyUtil.getBuild(this.myDevice);
        }
        return this.myDeviceBuild;
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> launch(@NotNull Project project) {
        return this.getLaunchedDevice();
    }

    @Override
    @NotNull
    public ListenableFuture<IDevice> getLaunchedDevice() {
        return Futures.immediateFuture((Object)this.myDevice);
    }

    @NotNull
    public IDevice getDevice() {
        return this.myDevice;
    }

    @Nullable
    private static DeviceNameRendererEx getRendererExtension(@NotNull IDevice device) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return null;
        }
        for (DeviceNameRendererEx extensionRenderer : (DeviceNameRendererEx[])EP_NAME.getExtensions()) {
            if (!extensionRenderer.isApplicable(device)) continue;
            return extensionRenderer;
        }
        return null;
    }

    @Override
    @NotNull
    public LaunchCompatibility canRun(@NotNull AndroidVersion minSdkVersion, @NotNull IAndroidTarget projectTarget, @NotNull EnumSet<IDevice.HardwareFeature> requiredFeatures, @Nullable Set<String> supportedAbis) {
        return LaunchCompatibility.canRunOnDevice(minSdkVersion, projectTarget, requiredFeatures, supportedAbis, this);
    }

    private boolean isDispatchThread() {
        Application application = ApplicationManager.getApplication();
        return application != null && application.isDispatchThread();
    }
}

