/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidDeviceComparator;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.DevicePickerEntry;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NotNull;

public class DevicePickerListModel
extends AbstractListModel<DevicePickerEntry> {
    private final ImmutableList<DevicePickerEntry> myEntries;
    private final boolean myShowSerialNumbers;
    private final int myNumConnectedDevices;

    public DevicePickerListModel() {
        this(Collections.emptyList(), Collections.emptyList());
    }

    public DevicePickerListModel(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avds) {
        List<AndroidDevice> connected = DevicePickerListModel.wrapConnectedDevices(connectedDevices, avds);
        this.myEntries = DevicePickerListModel.createEntries(connected, DevicePickerListModel.getLaunchableDevices(avds, DevicePickerListModel.getRunningAvds(connectedDevices)));
        this.myNumConnectedDevices = connected.size();
        this.myShowSerialNumbers = DevicePickerListModel.shouldShowSerials(connected);
    }

    public void entryContentChanged(@NotNull DevicePickerEntry entry) {
        int index = this.findEntry(entry);
        if (index >= 0) {
            this.fireContentsChanged(entry, index, index);
        }
    }

    private int findEntry(DevicePickerEntry entry) {
        for (int i = 0; i < this.myEntries.size(); ++i) {
            if (!((DevicePickerEntry)this.myEntries.get(i)).equals(entry)) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private static List<AndroidDevice> wrapConnectedDevices(@NotNull List<IDevice> connectedDevices, @NotNull List<AvdInfo> avdInfos) {
        ArrayList<AndroidDevice> devices = new ArrayList<AndroidDevice>(connectedDevices.size());
        for (IDevice device : connectedDevices) {
            devices.add(new ConnectedAndroidDevice(device, avdInfos));
        }
        return devices;
    }

    @NotNull
    private static List<AndroidDevice> getLaunchableDevices(@NotNull List<AvdInfo> avds, @NotNull Set<String> runningAvds) {
        ArrayList<AndroidDevice> launchable = new ArrayList<AndroidDevice>();
        for (AvdInfo avdInfo : avds) {
            if (runningAvds.contains(avdInfo.getName())) continue;
            launchable.add(new LaunchableAndroidDevice(avdInfo));
        }
        return launchable;
    }

    private static Set<String> getRunningAvds(@NotNull List<IDevice> connectedDevices) {
        HashSet<String> runningAvdNames = new HashSet<String>();
        for (IDevice device : connectedDevices) {
            String avdName;
            if (!device.isEmulator() || (avdName = device.getAvdName()) == null) continue;
            runningAvdNames.add(avdName);
        }
        return runningAvdNames;
    }

    @NotNull
    private static ImmutableList<DevicePickerEntry> createEntries(@NotNull List<AndroidDevice> connected, @NotNull List<AndroidDevice> launchable) {
        ImmutableList.Builder entries = ImmutableList.builder();
        AndroidDeviceComparator comparator = new AndroidDeviceComparator();
        Collections.sort(connected, comparator);
        Collections.sort(launchable, comparator);
        entries.add((Object)DevicePickerEntry.CONNECTED_DEVICES_MARKER);
        if (!connected.isEmpty()) {
            for (AndroidDevice device : connected) {
                entries.add((Object)DevicePickerEntry.create(device));
            }
        } else {
            entries.add((Object)DevicePickerEntry.NONE);
        }
        if (!launchable.isEmpty()) {
            entries.add((Object)DevicePickerEntry.LAUNCHABLE_DEVICES_MARKER);
            for (AndroidDevice device : launchable) {
                entries.add((Object)DevicePickerEntry.create(device));
            }
        }
        return entries.build();
    }

    public int getNumberOfConnectedDevices() {
        return this.myNumConnectedDevices;
    }

    private static boolean shouldShowSerials(@NotNull List<AndroidDevice> connectedDevices) {
        int numberOfPhysicalDevices = 0;
        for (AndroidDevice device : connectedDevices) {
            if (device.isVirtual()) continue;
            ++numberOfPhysicalDevices;
        }
        if (numberOfPhysicalDevices > 1) {
            HashSet<String> deviceNames = new HashSet<String>();
            for (AndroidDevice device : connectedDevices) {
                String name;
                if (device.isVirtual() || deviceNames.add(name = device.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getSize() {
        return this.myEntries.size();
    }

    @Override
    public DevicePickerEntry getElementAt(int index) {
        return (DevicePickerEntry)this.myEntries.get(index);
    }

    @NotNull
    public List<DevicePickerEntry> getItems() {
        return this.myEntries;
    }

    public boolean shouldShowSerialNumbers() {
        return this.myShowSerialNumbers;
    }
}

