/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.build.OutputFile;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.InstantAppProjectBuildOutput;
import com.android.builder.model.InstantAppVariantBuildOutput;
import com.android.builder.model.ProjectBuildOutput;
import com.android.builder.model.TestVariantBuildOutput;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.VariantBuildOutput;
import com.android.ddmlib.IDevice;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.run.PostBuildModel;
import com.android.tools.idea.gradle.run.PostBuildModelProvider;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.BestOutputFinder;
import com.android.tools.idea.run.ValidationError;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class GradleApkProvider
implements ApkProvider {
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final PostBuildModelProvider myOutputModelProvider;
    @NotNull
    private final BestOutputFinder myBestOutputFinder;
    private final boolean myTest;

    public GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, boolean test) {
        this(facet, applicationIdProvider, () -> null, test);
    }

    public GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, boolean test) {
        this(facet, applicationIdProvider, outputModelProvider, new BestOutputFinder(), test);
    }

    @VisibleForTesting
    GradleApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull PostBuildModelProvider outputModelProvider, @NotNull BestOutputFinder bestOutputFinder, boolean test) {
        this.myFacet = facet;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myOutputModelProvider = outputModelProvider;
        this.myBestOutputFinder = bestOutputFinder;
        this.myTest = test;
    }

    @Override
    @NotNull
    public Collection<ApkInfo> getApks(@NotNull IDevice device) throws ApkProvisionException {
        AndroidModuleModel androidModel = AndroidModuleModel.get(this.myFacet);
        if (androidModel == null) {
            GradleApkProvider.getLogger().warn("Android model is null. Sync might have failed");
            return Collections.emptyList();
        }
        IdeVariant selectedVariant = androidModel.getSelectedVariant();
        ArrayList<ApkInfo> apkList = new ArrayList<ApkInfo>();
        int projectType = androidModel.getAndroidProject().getProjectType();
        if (projectType == 0 || projectType == 4 || projectType == 2) {
            File apk = this.getApk(selectedVariant, device, this.myFacet, false);
            String pkgName = projectType == 2 ? this.myApplicationIdProvider.getTestPackageName() : this.myApplicationIdProvider.getPackageName();
            apkList.add(new ApkInfo(apk, pkgName));
        }
        apkList.addAll(GradleApkProvider.getAdditionalApks(selectedVariant.getMainArtifact()));
        if (this.myTest) {
            if (projectType == 2) {
                if (androidModel.getFeatures().isTestedTargetVariantsSupported()) {
                    apkList.addAll(0, this.getTargetedApks(selectedVariant, device));
                }
            } else {
                IdeAndroidArtifact testArtifactInfo = androidModel.getSelectedVariant().getAndroidTestArtifact();
                if (testArtifactInfo != null) {
                    File testApk = this.getApk(androidModel.getSelectedVariant(), device, this.myFacet, true);
                    String testPackageName = this.myApplicationIdProvider.getTestPackageName();
                    assert (testPackageName != null);
                    apkList.add(new ApkInfo(testApk, testPackageName));
                    apkList.addAll(GradleApkProvider.getAdditionalApks(testArtifactInfo));
                }
            }
        }
        return apkList;
    }

    @NotNull
    private static List<ApkInfo> getAdditionalApks(@NotNull AndroidArtifact testArtifactInfo) {
        ArrayList<ApkInfo> result = new ArrayList<ApkInfo>();
        for (File fileApk : testArtifactInfo.getAdditionalRuntimeApks()) {
            try {
                String packageId = GradleApkProvider.getPackageId(fileApk);
                result.add(new ApkInfo(fileApk, packageId));
            }
            catch (ApkProvisionException e) {
                GradleApkProvider.getLogger().error("Failed to get the package name from the given file. Therefore, we are not be able to install it. Please install it manually: " + fileApk.getName() + " error: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPackageId(@NotNull File fileApk) throws ApkProvisionException {
        try (Archive archive = Archives.open((Path)fileApk.toPath());){
            AndroidApplicationInfo applicationInfo = ApkParser.getAppInfo(archive);
            if (applicationInfo == AndroidApplicationInfo.UNKNOWN) {
                throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName());
            }
            String string = applicationInfo.packageId;
            return string;
        }
        catch (IOException e) {
            throw new ApkProvisionException("Could not determine manifest package for apk: " + fileApk.getName(), e.getCause());
        }
    }

    @VisibleForTesting
    @NotNull
    File getApk(@NotNull IdeVariant variant, @NotNull IDevice device, @NotNull AndroidFacet facet, boolean fromTestArtifact) throws ApkProvisionException {
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        assert (androidModel != null);
        if (androidModel.getFeatures().isPostBuildSyncSupported()) {
            return this.getApkFromPostBuildSync(variant, device, facet, fromTestArtifact);
        }
        return this.getApkFromPreBuildSync(variant, device, fromTestArtifact);
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPreBuildSync(@NotNull IdeVariant variant, @NotNull IDevice device, boolean fromTestArtifact) throws ApkProvisionException {
        IdeAndroidArtifact artifact;
        IdeAndroidArtifact ideAndroidArtifact = artifact = fromTestArtifact ? variant.getAndroidTestArtifact() : variant.getMainArtifact();
        assert (artifact != null);
        ArrayList outputs = new ArrayList(artifact.getOutputs());
        return this.getBestOutput(variant, device, outputs);
    }

    @NotNull
    @VisibleForTesting
    File getApkFromPostBuildSync(@NotNull IdeVariant variant, @NotNull IDevice device, @NotNull AndroidFacet facet, boolean fromTestArtifact) throws ApkProvisionException {
        ArrayList<OutputFile> outputs = new ArrayList<OutputFile>();
        PostBuildModel outputModels = this.myOutputModelProvider.getPostBuildModel();
        if (outputModels == null) {
            return this.getApkFromPreBuildSync(variant, device, fromTestArtifact);
        }
        if (facet.getProjectType() == 4) {
            InstantAppProjectBuildOutput outputModel = outputModels.findInstantAppProjectBuildOutput(facet);
            if (outputModel == null) {
                throw new ApkProvisionException("Couldn't get post build model for Instant Apps. Please, make sure to use plugin 3.0.0-alpha10 or later.");
            }
            for (InstantAppVariantBuildOutput instantAppVariantBuildOutput : outputModel.getInstantAppVariantsBuildOutput()) {
                if (!instantAppVariantBuildOutput.getName().equals(variant.getName())) continue;
                outputs.add(instantAppVariantBuildOutput.getOutput());
            }
        } else {
            ProjectBuildOutput outputModel = outputModels.findProjectBuildOutput(facet);
            if (outputModel == null) {
                return this.getApkFromPreBuildSync(variant, device, fromTestArtifact);
            }
            for (VariantBuildOutput variantBuildOutput : outputModel.getVariantsBuildOutput()) {
                if (!variantBuildOutput.getName().equals(variant.getName())) continue;
                if (fromTestArtifact) {
                    for (TestVariantBuildOutput testVariantBuildOutput : variantBuildOutput.getTestingVariants()) {
                        if (!testVariantBuildOutput.getType().equals(TestVariantBuildOutput.ANDROID_TEST)) continue;
                        outputs.addAll(testVariantBuildOutput.getOutputs());
                    }
                    continue;
                }
                outputs.addAll(variantBuildOutput.getOutputs());
            }
        }
        return outputs.isEmpty() ? this.getApkFromPreBuildSync(variant, device, fromTestArtifact) : this.getBestOutput(variant, device, outputs);
    }

    @NotNull
    private File getBestOutput(@NotNull IdeVariant variant, @NotNull IDevice device, @NotNull List<? extends OutputFile> outputs) throws ApkProvisionException {
        if (outputs.isEmpty()) {
            throw new ApkProvisionException("No outputs for the main artifact of variant: " + variant.getDisplayName());
        }
        List<OutputFile> apkFiles = this.myBestOutputFinder.findBestOutput(variant, device, outputs);
        return apkFiles.get(0).getOutputFile();
    }

    @NotNull
    private List<ApkInfo> getTargetedApks(@NotNull IdeVariant selectedVariant, @NotNull IDevice device) throws ApkProvisionException {
        ArrayList<ApkInfo> targetedApks = new ArrayList<ApkInfo>();
        for (TestedTargetVariant testedVariant : selectedVariant.getTestedTargetVariants()) {
            String targetGradlePath = testedVariant.getTargetProjectPath();
            Module targetModule = (Module)ApplicationManager.getApplication().runReadAction(() -> {
                Project project = this.myFacet.getModule().getProject();
                return GradleUtil.findModuleByGradlePath(project, targetGradlePath);
            });
            if (targetModule == null) {
                GradleApkProvider.getLogger().warn(String.format("Module not found for gradle path %s. Please install tested apk manually.", targetGradlePath));
                continue;
            }
            AndroidFacet targetFacet = AndroidFacet.getInstance(targetModule);
            if (targetFacet == null) {
                GradleApkProvider.getLogger().warn("Android facet for tested module is null. Please install tested apk manually.");
                continue;
            }
            AndroidModuleModel targetAndroidModel = AndroidModuleModel.get(targetModule);
            if (targetAndroidModel == null) {
                GradleApkProvider.getLogger().warn("Android model for tested module is null. Sync might have failed.");
                continue;
            }
            IdeVariant targetVariant = (IdeVariant)targetAndroidModel.findVariantByName(testedVariant.getTargetVariant());
            if (targetVariant == null) {
                GradleApkProvider.getLogger().warn("Tested variant not found. Sync might have failed.");
                continue;
            }
            File targetApk = this.getApk(targetVariant, device, targetFacet, false);
            String applicationId = targetVariant.getMergedFlavor().getApplicationId();
            if (applicationId == null) {
                applicationId = ApkProviderUtil.computePackageName(targetFacet);
            }
            targetedApks.add(new ApkInfo(targetApk, applicationId));
        }
        return targetedApks;
    }

    @Override
    @NotNull
    public List<ValidationError> validate() {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(this.myFacet);
        assert (androidModuleModel != null);
        if (androidModuleModel.getAndroidProject().getProjectType() == 4 || androidModuleModel.getMainArtifact().isSigned()) {
            return ImmutableList.of();
        }
        AndroidArtifactOutput output = GradleUtil.getOutput(androidModuleModel.getMainArtifact());
        String message = AndroidBundle.message("run.error.apk.not.signed", output.getMainOutputFile().getOutputFile().getName(), androidModuleModel.getSelectedVariant().getDisplayName());
        Runnable quickFix = () -> {
            Module module = this.myFacet.getModule();
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)module.getProject());
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openSigningConfiguration(module);
            } else {
                service.openModuleSettings(module);
            }
        };
        return ImmutableList.of((Object)ValidationError.fatal(message, quickFix));
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleApkProvider.class);
    }
}

