/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class RetryingInstaller {
    private final IDevice myDevice;
    private final Installer myInstaller;
    private final String myApplicationId;
    private final ConsolePrinter myPrinter;
    private final LaunchStatus myLaunchStatus;
    private final Prompter myPrompter;

    public RetryingInstaller(@NotNull Project project, @NotNull IDevice device, @NotNull Installer installer, @NotNull String applicationId, @NotNull ConsolePrinter printer, @NotNull LaunchStatus launchStatus) {
        this(device, installer, applicationId, new UserPrompter(project), printer, launchStatus);
    }

    public RetryingInstaller(@NotNull IDevice device, @NotNull Installer installer, @NotNull String applicationId, @NotNull Prompter prompter, @NotNull ConsolePrinter printer, @NotNull LaunchStatus launchStatus) {
        this.myDevice = device;
        this.myInstaller = installer;
        this.myApplicationId = applicationId;
        this.myPrompter = prompter;
        this.myPrinter = printer;
        this.myLaunchStatus = launchStatus;
    }

    public boolean install() {
        InstallResult result = null;
        boolean retry = true;
        block12: while (!this.myLaunchStatus.isLaunchTerminated() && retry) {
            result = this.myInstaller.installApp(this.myDevice, this.myLaunchStatus);
            if (result.installOutput != null) {
                if (result.failureCode == InstallResult.FailureCode.NO_ERROR) {
                    this.myPrinter.stdout(result.installOutput);
                } else {
                    this.myPrinter.stderr(result.installOutput);
                }
            }
            switch (result.failureCode) {
                case DEVICE_NOT_RESPONDING: {
                    int waitTime = 2;
                    this.myPrinter.stdout("Device is not ready. Waiting for " + waitTime + " seconds.");
                    try {
                        TimeUnit.SECONDS.sleep(waitTime);
                    }
                    catch (InterruptedException e) {
                        Logger.getInstance(RetryingInstaller.class).info((Throwable)e);
                    }
                    retry = true;
                    continue block12;
                }
                case INSTALL_FAILED_VERSION_DOWNGRADE: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.version.downgrade", new Object[0]));
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
                case INSTALL_FAILED_UPDATE_INCOMPATIBLE: 
                case INCONSISTENT_CERTIFICATES: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.different.signature", new Object[0]));
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
                case INSTALL_FAILED_DEXOPT: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.text", AndroidBundle.message("deployment.failed.reason.dexopt", new Object[0]));
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
                case NO_CERTIFICATE: {
                    this.myPrinter.stderr(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]));
                    this.myPrompter.showErrorMessage(AndroidBundle.message("deployment.failed.no.certificates.explanation", new Object[0]));
                    retry = false;
                    continue block12;
                }
                case INSTALL_FAILED_OLDER_SDK: {
                    String message = AndroidBundle.message("deployment.failed.reason.oldersdk", this.myDevice.getVersion().toString());
                    this.myPrinter.stderr(message);
                    retry = false;
                    continue block12;
                }
                case DEVICE_NOT_FOUND: {
                    String reason = AndroidBundle.message("deployment.failed.reason.devicedisconnected", this.myDevice.getName());
                    this.myPrompter.showErrorMessage(reason);
                    retry = false;
                    continue block12;
                }
                case UNTYPED_ERROR: {
                    String reason = AndroidBundle.message("deployment.failed.uninstall.prompt.generic.text", result.failureMessage);
                    retry = this.myPrompter.showQuestionPrompt(reason) && this.uninstallPackage(this.myDevice, this.myApplicationId);
                    continue block12;
                }
            }
            retry = false;
        }
        return result != null && result.failureCode == InstallResult.FailureCode.NO_ERROR;
    }

    private boolean uninstallPackage(@NotNull IDevice device, @NotNull String packageName) {
        String output;
        this.myPrinter.stdout("$ adb shell pm uninstall " + packageName);
        try {
            output = device.uninstallPackage(packageName);
        }
        catch (InstallException e) {
            return false;
        }
        if (output != null) {
            this.myPrinter.stderr(output);
            return false;
        }
        return true;
    }

    public static class UserPrompter
    implements Prompter {
        private final Project myProject;

        public UserPrompter(@NotNull Project project) {
            this.myProject = project;
        }

        @Override
        public boolean showQuestionPrompt(@NotNull String message) {
            return (Boolean)UIUtil.invokeAndWaitIfNeeded(() -> {
                int result = Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)AndroidBundle.message("deployment.failed.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                return result == 0;
            });
        }

        @Override
        public void showErrorMessage(@NotNull String message) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.myProject, (String)message, (String)AndroidBundle.message("deployment.failed.title", new Object[0])));
        }
    }

    public static interface Prompter {
        public boolean showQuestionPrompt(@NotNull String var1);

        public void showErrorMessage(@NotNull String var1);
    }

    public static interface Installer {
        @NotNull
        public InstallResult installApp(@NotNull IDevice var1, @NotNull LaunchStatus var2);
    }
}

