/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.google.common.base.Predicate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TargetDeviceFilter
implements Predicate<IDevice> {
    public boolean apply(@Nullable IDevice device) {
        return device != null && this.matchesDevice(device);
    }

    public abstract boolean matchesDevice(@NotNull IDevice var1);

    public static class UsbDeviceFilter
    extends TargetDeviceFilter {
        @Override
        public boolean matchesDevice(@NotNull IDevice device) {
            return !device.isEmulator();
        }
    }

    public static class EmulatorFilter
    extends TargetDeviceFilter {
        @NotNull
        private final AndroidFacet myFacet;
        @Nullable
        private final String myPreferredAvd;

        public EmulatorFilter(@NotNull AndroidFacet facet, @Nullable String preferredAvd) {
            this.myFacet = facet;
            this.myPreferredAvd = preferredAvd;
        }

        @Override
        public boolean matchesDevice(@NotNull IDevice device) {
            if (!device.isEmulator()) {
                return false;
            }
            String avdName = device.getAvdName();
            if (this.myPreferredAvd != null) {
                return this.myPreferredAvd.equals(avdName);
            }
            AndroidPlatform androidPlatform = ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getAndroidPlatform();
            if (androidPlatform == null) {
                Logger.getInstance(EmulatorFilter.class).warn("Target Android platform not set for module: " + this.myFacet.getModule().getName());
                return false;
            }
            ConnectedAndroidDevice connectedDevice = new ConnectedAndroidDevice(device, null);
            Set supportedAbis = this.myFacet.getAndroidModel() instanceof AndroidModuleModel ? ((AndroidModuleModel)this.myFacet.getAndroidModel()).getSelectedVariant().getMainArtifact().getAbiFilters() : null;
            LaunchCompatibility compatibility = connectedDevice.canRun(AndroidModuleInfo.getInstance(this.myFacet).getRuntimeMinSdkVersion(), androidPlatform.getTarget(), EnumSet.noneOf(IDevice.HardwareFeature.class), supportedAbis);
            return compatibility.isCompatible() != ThreeState.NO;
        }
    }
}

