/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ValidationError
implements Comparable<ValidationError> {
    @NotNull
    private final Severity mySeverity;
    @NotNull
    private final String myMessage;
    @Nullable
    private final Category myCategory;
    @Nullable
    private final Runnable myQuickfix;

    private ValidationError(@NotNull Severity severity, @NotNull String message, @Nullable Category category, @Nullable Runnable quickfix) {
        this.mySeverity = severity;
        this.myMessage = message;
        this.myCategory = category;
        this.myQuickfix = quickfix;
    }

    @NotNull
    public static ValidationError fatal(@NotNull String message) {
        return ValidationError.fatal(message, null);
    }

    @NotNull
    public static ValidationError fatal(@NotNull String message, @Nullable Runnable quickfix) {
        return new ValidationError(Severity.FATAL, message, null, quickfix);
    }

    @NotNull
    public static ValidationError fatal(@NotNull String message, @Nullable Category category, @Nullable Runnable quickfix) {
        return new ValidationError(Severity.FATAL, message, category, quickfix);
    }

    @NotNull
    public static ValidationError warning(@NotNull String message) {
        return ValidationError.warning(message, null);
    }

    @NotNull
    public static ValidationError warning(@NotNull String message, @Nullable Runnable quickfix) {
        return new ValidationError(Severity.WARNING, message, null, quickfix);
    }

    @NotNull
    public static ValidationError warning(@NotNull String message, @Nullable Category category, @Nullable Runnable quickfix) {
        return new ValidationError(Severity.WARNING, message, category, quickfix);
    }

    @NotNull
    public static ValidationError info(@NotNull String message) {
        return ValidationError.info(message, null);
    }

    @NotNull
    public static ValidationError info(@NotNull String message, @Nullable Runnable quickfix) {
        return new ValidationError(Severity.INFO, message, null, quickfix);
    }

    @NotNull
    public static ValidationError info(@NotNull String message, @Nullable Category category, @Nullable Runnable quickfix) {
        return new ValidationError(Severity.INFO, message, category, quickfix);
    }

    @NotNull
    public static ValidationError fromException(@NotNull RuntimeConfigurationException e) {
        if (e instanceof RuntimeConfigurationError) {
            return ValidationError.fatal(e.getMessage(), e.getQuickFix());
        }
        return ValidationError.warning(e.getMessage(), e.getQuickFix());
    }

    @NotNull
    public Severity getSeverity() {
        return this.mySeverity;
    }

    @NotNull
    public String getMessage() {
        return this.myMessage;
    }

    @Nullable
    public Category getCategory() {
        return this.myCategory;
    }

    @Nullable
    public Runnable getQuickfix() {
        return this.myQuickfix;
    }

    public boolean isFatal() {
        return this.mySeverity.equals((Object)Severity.FATAL);
    }

    @Override
    public int compareTo(ValidationError o) {
        return this.mySeverity.compareTo(o.getSeverity());
    }

    public static enum Category {
        PROFILER;

    }

    public static enum Severity {
        WARNING,
        FATAL,
        INFO;

    }
}

