/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.fd.InstantRunConfigurable;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ConfigurationSpecificEditor;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidDebuggerContext;
import com.android.tools.idea.run.editor.AndroidDebuggerPanel;
import com.android.tools.idea.run.editor.AndroidProfilersPanel;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeployTargetConfigurableWrapper;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.RunConfigurationEditorContext;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidRunConfigurationEditor<T extends AndroidRunConfigurationBase>
extends SettingsEditor<T>
implements PanelWithAnchor,
HyperlinkListener,
ActionListener,
GradleSyncListener {
    private JPanel myPanel;
    protected JBTabbedPane myTabbedPane;
    private JBLabel myModuleJBLabel;
    private ModulesComboBox myModulesComboBox;
    private JPanel myConfigurationSpecificPanel;
    private ConfigurableCardPanel myDeployTargetConfigurableCardPanel;
    private ComboBox myDeploymentTargetCombo;
    private JCheckBox myClearLogCheckBox;
    private JCheckBox myShowLogcatCheckBox;
    private JCheckBox mySkipNoOpApkInstallation;
    private JCheckBox myForceStopRunningApplicationCheckBox;
    private HyperlinkLabel myOldVersionLabel;
    private JComponent anchor;
    private final ConfigurationModuleSelector myModuleSelector;
    private ConfigurationSpecificEditor<T> myConfigurationSpecificEditor;
    private final ImmutableMap<String, DeployTargetConfigurableWrapper> myDeployTargetConfigurables;
    private final List<DeployTargetProvider> myApplicableDeployTargetProviders;
    private AndroidDebuggerPanel myAndroidDebuggerPanel;
    private final AndroidProfilersPanel myAndroidProfilersPanel;

    public AndroidRunConfigurationEditor(Project project, final Predicate<AndroidFacet> libraryProjectValidator, T config) {
        this.$$$setupUI$$$();
        Disposer.register((Disposable)project, (Disposable)this);
        this.myModuleSelector = new ConfigurationModuleSelector(project, this.myModulesComboBox){

            public boolean isModuleAccepted(Module module) {
                if (module == null || !super.isModuleAccepted(module)) {
                    return false;
                }
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null) {
                    return false;
                }
                return !facet.isLibraryProject() || libraryProjectValidator.apply((Object)facet);
            }
        };
        this.myModulesComboBox.addActionListener((ActionListener)this);
        this.myApplicableDeployTargetProviders = ImmutableList.copyOf(((AndroidRunConfigurationBase)config).getApplicableDeployTargetProviders());
        RunConfigurationEditorContext context = new RunConfigurationEditorContext(this.myModuleSelector, (JComboBox)this.myModulesComboBox);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTargetProvider target : this.myApplicableDeployTargetProviders) {
            builder.put((Object)target.getId(), (Object)new DeployTargetConfigurableWrapper(project, (Disposable)this, context, target));
        }
        this.myDeployTargetConfigurables = builder.build();
        this.myDeploymentTargetCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(this.myApplicableDeployTargetProviders));
        this.myDeploymentTargetCombo.setRenderer((ListCellRenderer)((Object)new DeployTargetProvider.Renderer()));
        this.myDeploymentTargetCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DeployTargetProvider target = (DeployTargetProvider)AndroidRunConfigurationEditor.this.myDeploymentTargetCombo.getSelectedItem();
                if (target != null) {
                    AndroidRunConfigurationEditor.this.myDeployTargetConfigurableCardPanel.select(AndroidRunConfigurationEditor.this.myDeployTargetConfigurables.get((Object)target.getId()), true);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AndroidRunConfigurationEditor.this.mySkipNoOpApkInstallation == e.getSource()) {
                    AndroidRunConfigurationEditor.this.myForceStopRunningApplicationCheckBox.setEnabled(AndroidRunConfigurationEditor.this.mySkipNoOpApkInstallation.isSelected());
                }
            }
        };
        this.mySkipNoOpApkInstallation.addActionListener(actionListener);
        final AndroidDebuggerContext androidDebuggerContext = ((AndroidRunConfigurationBase)config).getAndroidDebuggerContext();
        this.myModulesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                androidDebuggerContext.setDebuggeeModule(AndroidRunConfigurationEditor.this.myModulesComboBox.getSelectedModule());
            }
        });
        if (androidDebuggerContext.getAndroidDebuggers().size() > 1) {
            this.myAndroidDebuggerPanel = new AndroidDebuggerPanel((RunConfiguration)config, androidDebuggerContext);
            this.myTabbedPane.add("Debugger", (Component)this.myAndroidDebuggerPanel.getComponent());
        }
        this.myAndroidProfilersPanel = new AndroidProfilersPanel(project, ((AndroidRunConfigurationBase)config).getProfilerState());
        this.myTabbedPane.add("Profiling", (Component)this.myAndroidProfilersPanel.getComponent());
        this.checkValidationResults(((AndroidRunConfigurationBase)config).validate(null));
    }

    public void setConfigurationSpecificEditor(ConfigurationSpecificEditor<T> configurationSpecificEditor) {
        this.myConfigurationSpecificEditor = configurationSpecificEditor;
        this.myConfigurationSpecificPanel.add(configurationSpecificEditor.getComponent());
        this.setAnchor(this.myConfigurationSpecificEditor.getAnchor());
        this.myShowLogcatCheckBox.setVisible(configurationSpecificEditor instanceof ApplicationRunParameters);
    }

    private void checkValidationResults(@NotNull List<ValidationError> errors) {
        if (errors.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors);
        if (ValidationError.Category.PROFILER.equals((Object)topError.getCategory())) {
            this.myTabbedPane.setSelectedComponent((Component)this.myAndroidProfilersPanel.getComponent());
        }
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModuleJBLabel.setAnchor(anchor);
    }

    protected void resetEditorFrom(@NotNull T configuration) {
        this.myModuleSelector.reset(configuration);
        DeployTargetContext deployTargetContext = ((AndroidRunConfigurationBase)configuration).getDeployTargetContext();
        this.myDeploymentTargetCombo.setSelectedItem((Object)deployTargetContext.getCurrentDeployTargetProvider());
        for (DeployTargetProvider target : this.myApplicableDeployTargetProviders) {
            DeployTargetState state = deployTargetContext.getDeployTargetState(target);
            ((DeployTargetConfigurableWrapper)this.myDeployTargetConfigurables.get((Object)target.getId())).resetFrom(state, configuration.getUniqueID());
        }
        this.myClearLogCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).CLEAR_LOGCAT);
        this.myShowLogcatCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).SHOW_LOGCAT_AUTOMATICALLY);
        this.mySkipNoOpApkInstallation.setSelected(((AndroidRunConfigurationBase)configuration).SKIP_NOOP_APK_INSTALLATIONS);
        this.myForceStopRunningApplicationCheckBox.setSelected(((AndroidRunConfigurationBase)configuration).FORCE_STOP_RUNNING_APP);
        this.myConfigurationSpecificEditor.resetFrom(configuration);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.resetFrom(((AndroidRunConfigurationBase)configuration).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.resetFrom(((AndroidRunConfigurationBase)configuration).getProfilerState());
    }

    protected void applyEditorTo(@NotNull T configuration) throws ConfigurationException {
        this.myModuleSelector.applyTo(configuration);
        DeployTargetContext deployTargetContext = ((AndroidRunConfigurationBase)configuration).getDeployTargetContext();
        deployTargetContext.setTargetSelectionMode((DeployTargetProvider)this.myDeploymentTargetCombo.getSelectedItem());
        for (DeployTargetProvider target : this.myApplicableDeployTargetProviders) {
            DeployTargetState state = deployTargetContext.getDeployTargetState(target);
            if (target == null) continue;
            ((DeployTargetConfigurableWrapper)this.myDeployTargetConfigurables.get((Object)target.getId())).applyTo(state, configuration.getUniqueID());
        }
        ((AndroidRunConfigurationBase)configuration).CLEAR_LOGCAT = this.myClearLogCheckBox.isSelected();
        ((AndroidRunConfigurationBase)configuration).SHOW_LOGCAT_AUTOMATICALLY = this.myShowLogcatCheckBox.isSelected();
        ((AndroidRunConfigurationBase)configuration).SKIP_NOOP_APK_INSTALLATIONS = this.mySkipNoOpApkInstallation.isSelected();
        ((AndroidRunConfigurationBase)configuration).FORCE_STOP_RUNNING_APP = this.myForceStopRunningApplicationCheckBox.isSelected();
        this.myConfigurationSpecificEditor.applyTo(configuration);
        if (this.myAndroidDebuggerPanel != null) {
            this.myAndroidDebuggerPanel.applyTo(((AndroidRunConfigurationBase)configuration).getAndroidDebuggerContext());
        }
        this.myAndroidProfilersPanel.applyTo(((AndroidRunConfigurationBase)configuration).getProfilerState());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.myPanel;
    }

    public ConfigurationModuleSelector getModuleSelector() {
        return this.myModuleSelector;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.myModulesComboBox) {
            this.updateLinkState();
            if (this.myConfigurationSpecificEditor instanceof ApplicationRunParameters) {
                ((ApplicationRunParameters)this.myConfigurationSpecificEditor).onModuleChanged();
            }
        }
    }

    private void createUIComponents() {
        this.myOldVersionLabel = new HyperlinkLabel();
        this.setSyncLinkMessage("");
        this.myOldVersionLabel.addHyperlinkListener((HyperlinkListener)this);
    }

    private void setSyncLinkMessage(@NotNull String syncMessage) {
        this.myOldVersionLabel.setHyperlinkText("Instant Run requires a newer version of the Gradle plugin. ", "Update Project", " " + syncMessage);
        this.myOldVersionLabel.repaint();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        Project project = this.getModuleSelector().getModule().getProject();
        if (!InstantRunConfigurable.updateProjectToInstantRunTools(project, this)) {
            this.setSyncLinkMessage("Error updating to new Gradle version");
        }
    }

    @Override
    public void syncStarted(@NotNull Project project) {
        this.setSyncLinkMessage("(Syncing)");
    }

    @Override
    public void setupStarted(@NotNull Project project) {
    }

    @Override
    public void syncSucceeded(@NotNull Project project) {
        this.syncFinished();
    }

    @Override
    public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
        this.setSyncLinkMessage("(Sync Failed)");
        this.syncFinished();
    }

    @Override
    public void syncSkipped(@NotNull Project project) {
        this.syncFinished();
    }

    private void syncFinished() {
        this.updateLinkState();
    }

    private void updateLinkState() {
        Module module = this.getModuleSelector().getModule();
        if (module == null) {
            this.myOldVersionLabel.setVisible(false);
            return;
        }
        AndroidModuleModel model = AndroidModuleModel.get(module);
        if (model == null || InstantRunGradleUtils.modelSupportsInstantRun(model)) {
            this.myOldVersionLabel.setVisible(false);
            return;
        }
        this.myOldVersionLabel.setVisible(true);
    }

    public ConfigurationSpecificEditor<T> getConfigurationSpecificEditor() {
        return this.myConfigurationSpecificEditor;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        ConfigurableCardPanel configurableCardPanel;
        ComboBox comboBox;
        JPanel jPanel;
        ModulesComboBox modulesComboBox;
        JBLabel jBLabel;
        JBTabbedPane jBTabbedPane;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(46, 14), null));
        this.myTabbedPane = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.general.tab.title"), null, jPanel3, null);
        this.myModuleJBLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module:");
        jBLabel.setDisplayedMnemonic('M');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myModulesComboBox = modulesComboBox = new ModulesComboBox();
        jPanel3.add((Component)modulesComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myConfigurationSpecificPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Deployment Target Options");
        jPanel3.add((Component)titledSeparator, new GridConstraints(3, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Target:");
        jBLabel2.setDisplayedMnemonic('T');
        jBLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 0, 1, 0, 0, null, null, null, 2));
        this.myDeploymentTargetCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myDeployTargetConfigurableCardPanel = configurableCardPanel = new ConfigurableCardPanel();
        jPanel3.add((Component)configurableCardPanel, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null, 4));
        HyperlinkLabel hyperlinkLabel = this.myOldVersionLabel;
        jPanel3.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 3, 0, 1, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.misc.tab.title"), null, jPanel4, null);
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Logcat", 0, 0, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClearLogCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.run.configuration.logcat.skip.content.label"));
        jPanel5.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowLogcatCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Show logcat automatically");
        jCheckBox3.setMnemonic('S');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Installation Options", 0, 0, null, null));
        this.mySkipNoOpApkInstallation = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Skip installation if APK has not changed");
        jPanel6.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel6.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel6.add((Component)spacer7, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myForceStopRunningApplicationCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Force stop running application before launching activity");
        jPanel6.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor((Component)modulesComboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

