/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployTargetContext
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(DeployTargetContext.class);
    public String TARGET_SELECTION_MODE = TargetSelectionMode.SHOW_DIALOG.name();
    private final List<DeployTargetProvider> myDeployTargetProviders = DeployTargetProvider.getProviders();
    private final Map<String, DeployTargetState> myDeployTargetStates;

    public DeployTargetContext() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DeployTargetProvider provider : this.myDeployTargetProviders) {
            builder.put((Object)provider.getId(), provider.createState());
        }
        this.myDeployTargetStates = builder.build();
    }

    @NotNull
    public List<DeployTargetProvider> getDeployTargetProviders() {
        return this.myDeployTargetProviders;
    }

    @NotNull
    public DeployTargetProvider getCurrentDeployTargetProvider() {
        DeployTargetProvider target = this.getDeployTargetProvider(this.TARGET_SELECTION_MODE);
        if (target == null) {
            target = this.getDeployTargetProvider(TargetSelectionMode.SHOW_DIALOG.name());
        }
        assert (target != null);
        return target;
    }

    @Nullable
    private DeployTargetProvider getDeployTargetProvider(@NotNull String id) {
        for (DeployTargetProvider target : this.myDeployTargetProviders) {
            if (!target.getId().equals(id)) continue;
            return target;
        }
        return null;
    }

    @NotNull
    public Map<String, DeployTargetState> getDeployTargetStates() {
        return this.myDeployTargetStates;
    }

    @NotNull
    public DeployTargetState getCurrentDeployTargetState() {
        DeployTargetProvider currentTarget = this.getCurrentDeployTargetProvider();
        return this.myDeployTargetStates.get(currentTarget.getId());
    }

    @NotNull
    public DeployTargetState getDeployTargetState(@NotNull DeployTargetProvider target) {
        return this.myDeployTargetStates.get(target.getId());
    }

    public void setTargetSelectionMode(@NotNull TargetSelectionMode mode) {
        this.TARGET_SELECTION_MODE = mode.name();
    }

    public void setTargetSelectionMode(@NotNull DeployTargetProvider target) {
        this.TARGET_SELECTION_MODE = target.getId();
    }

    @NotNull
    public TargetSelectionMode getTargetSelectionMode() {
        try {
            return TargetSelectionMode.valueOf(this.TARGET_SELECTION_MODE);
        }
        catch (IllegalArgumentException e) {
            LOG.info((Throwable)e);
            return TargetSelectionMode.EMULATOR;
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state, (Element)element);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        for (DeployTargetState state : this.myDeployTargetStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state, (Element)element);
        }
    }
}

