/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.editor;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.avdmanager.ModuleAvds;
import com.android.tools.idea.run.DeviceCount;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.EmulatorTargetChooser;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.EmulatorTargetConfigurable;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmulatorTargetProvider
extends DeployTargetProvider<State> {
    @Override
    @NotNull
    public String getId() {
        return TargetSelectionMode.EMULATOR.name();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "Emulator";
    }

    @Override
    @NotNull
    public State createState() {
        return new State();
    }

    @Override
    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        return new EmulatorTargetConfigurable(project, parentDisposable, context);
    }

    @Override
    public DeployTarget<State> getDeployTarget() {
        return new DeployTarget<State>(){

            @Override
            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                return false;
            }

            @Override
            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull State state) throws ExecutionException {
                return null;
            }

            @Override
            @Nullable
            public DeviceFutures getDevices(@NotNull State state, @NotNull AndroidFacet facet, @NotNull DeviceCount deviceCount, boolean debug, int runConfigId) {
                return new EmulatorTargetChooser(facet, Strings.emptyToNull((String)state.PREFERRED_AVD)).getDevices(deviceCount);
            }
        };
    }

    public static final class State
    extends DeployTargetState {
        public String PREFERRED_AVD = "";

        @Override
        @NotNull
        public List<ValidationError> validate(@NotNull AndroidFacet facet) {
            if (StringUtil.isEmpty((String)this.PREFERRED_AVD)) {
                return ImmutableList.of();
            }
            AvdManager avdManager = ModuleAvds.getInstance(facet).getAvdManagerSilently();
            if (avdManager == null) {
                return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.cannot.be.loaded.error", new Object[0])));
            }
            AvdInfo avdInfo = avdManager.getAvd(this.PREFERRED_AVD, false);
            if (avdInfo == null) {
                return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("avd.not.found.error", this.PREFERRED_AVD)));
            }
            if (avdInfo.getStatus() != AvdInfo.AvdStatus.OK) {
                String message = avdInfo.getErrorMessage();
                message = AndroidBundle.message("avd.not.valid.error", this.PREFERRED_AVD) + (message != null ? ": " + message : "") + ". Try to repair it through AVD manager";
                return ImmutableList.of((Object)ValidationError.fatal(message));
            }
            return ImmutableList.of();
        }
    }
}

