/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.ShellCommandLauncher;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidDeepLinkLaunchTask
implements LaunchTask {
    @NotNull
    private final String myDeepLink;
    @NotNull
    StartActivityFlagsProvider myStartActivityFlagsProvider;

    public AndroidDeepLinkLaunchTask(@NotNull String deepLink, @NotNull StartActivityFlagsProvider startActivityFlagsProvider) {
        this.myDeepLink = deepLink;
        this.myStartActivityFlagsProvider = startActivityFlagsProvider;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Launching URL";
    }

    @Override
    public int getDuration() {
        return 2;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        printer.stdout("Launching deeplink: " + this.myDeepLink + ".\n");
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.APP_INDEXING).setKind(AndroidStudioEvent.EventKind.APP_INDEXING_DEEP_LINK_LAUNCHED));
        ShellCommandLauncher.execute("setprop log.tag.AppIndexApi VERBOSE", device, launchStatus, printer, 5L, TimeUnit.SECONDS);
        String command = AndroidDeepLinkLaunchTask.getLaunchDeepLinkCommand(this.myDeepLink, this.myStartActivityFlagsProvider.getFlags(device));
        return ShellCommandLauncher.execute(command, device, launchStatus, printer, 5L, TimeUnit.SECONDS);
    }

    @NotNull
    public static String getLaunchDeepLinkCommand(@NotNull String deepLink, @NotNull String extraFlags) {
        return "am start -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + deepLink + (extraFlags.isEmpty() ? "" : " " + extraFlags);
    }
}

