/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.google.idea.blaze.android.run.test.ReattachingDebugConnectorTaskBase;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestOrchestratorJavaDebuggerTask
extends ReattachingDebugConnectorTaskBase {
    private AndroidProcessHandler orchestratorHandler;

    public AndroidTestOrchestratorJavaDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess) {
        super(applicationIds, debugger, project, monitorRemoteProcess);
    }

    @Override
    @Nullable
    public ProcessHandler perform(@NotNull LaunchInfo launchInfo, @NotNull IDevice device, @NotNull ProcessHandlerLaunchStatus status, @NotNull ProcessHandlerConsolePrinter printer) {
        this.orchestratorHandler = new AndroidProcessHandler("android.support.test.orchestrator", true);
        this.orchestratorHandler.addTargetDevice(device);
        this.orchestratorHandler.startNotify();
        return super.perform(launchInfo, device, status, printer);
    }

    @Override
    protected void registerLaunchTaskCompleteCallback(final @NotNull Runnable runnable) {
        this.orchestratorHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                runnable.run();
            }
        });
        if (this.orchestratorHandler.isProcessTerminated()) {
            runnable.run();
        }
    }

    @Override
    @NotNull
    public ProcessHandler createDebugProcessHandler(@NotNull ProcessHandlerLaunchStatus launchStatus) {
        AndroidRemoteDebugProcessHandler newHandler = new AndroidRemoteDebugProcessHandler(this.myProject, this.myMonitorRemoteProcess);
        newHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                if (willBeDestroyed) {
                    AndroidTestOrchestratorJavaDebuggerTask.this.orchestratorHandler.destroyProcess();
                }
            }
        });
        AndroidProcessText.attach(newHandler);
        return newHandler;
    }

    @Override
    @NotNull
    public RunContentDescriptor getDescriptor(@NotNull LaunchInfo currentLaunchInfo, @NotNull ProcessHandlerLaunchStatus launchStatus) {
        AndroidSessionInfo oldSession = (AndroidSessionInfo)this.getOldProcessHandler(currentLaunchInfo, launchStatus).getUserData(AndroidSessionInfo.KEY);
        assert (oldSession != null);
        return oldSession.getDescriptor();
    }

    @Override
    @NotNull
    public ProcessHandler getOldProcessHandler(@NotNull LaunchInfo currentLaunchInfo, @NotNull ProcessHandlerLaunchStatus launchStatus) {
        return launchStatus.getProcessHandler();
    }
}

