/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.DebugConnectorTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.google.common.base.Joiner;
import com.google.common.util.concurrent.Uninterruptibles;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectDebuggerTask
implements DebugConnectorTask {
    private static final int POLL_TIMEOUT = 15;
    private static final TimeUnit POLL_TIMEUNIT = TimeUnit.SECONDS;
    @NotNull
    protected final Set<String> myApplicationIds;
    @NotNull
    protected final AndroidDebugger myDebugger;
    @NotNull
    protected final Project myProject;
    protected final boolean myMonitorRemoteProcess;
    protected final boolean myAttachToRunningProcess;

    protected ConnectDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess) {
        this(applicationIds, debugger, project, monitorRemoteProcess, false);
    }

    protected ConnectDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess, boolean attachToRunningProcess) {
        this.myApplicationIds = applicationIds;
        this.myDebugger = debugger;
        this.myProject = project;
        this.myMonitorRemoteProcess = monitorRemoteProcess;
        this.myAttachToRunningProcess = attachToRunningProcess;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Connecting Debugger";
    }

    @Override
    public int getDuration() {
        return 10;
    }

    @Override
    public ProcessHandler perform(@NotNull LaunchInfo launchInfo, @NotNull IDevice device, @NotNull ProcessHandlerLaunchStatus state, @NotNull ProcessHandlerConsolePrinter printer) {
        Client client = this.waitForClient(device, state, printer);
        if (client == null) {
            return null;
        }
        return (ProcessHandler)UIUtil.invokeAndWaitIfNeeded(() -> this.launchDebugger(launchInfo, client, state, printer));
    }

    @Nullable
    protected Client waitForClient(@NotNull IDevice device, @NotNull LaunchStatus state, @NotNull ConsolePrinter printer) {
        for (int i = 0; i < 15; ++i) {
            if (state.isLaunchTerminated()) {
                return null;
            }
            if (!device.isOnline()) {
                printer.stderr("Device is offline");
                return null;
            }
            block6: for (String name : this.myApplicationIds) {
                Client client = device.getClient(name);
                if (client == null) {
                    printer.stdout("Waiting for application to come online: " + Joiner.on((String)" | ").join(this.myApplicationIds));
                    continue;
                }
                printer.stdout("Connecting to " + name);
                ClientData.DebuggerStatus status = client.getClientData().getDebuggerConnectionStatus();
                switch (status) {
                    case ERROR: {
                        String message = String.format(Locale.US, "Debug port (%1$d) is busy, make sure there is no other active debug connection to the same application", client.getDebuggerListenPort());
                        printer.stderr(message);
                        return null;
                    }
                    case ATTACHED: {
                        printer.stderr("A debugger is already attached");
                        return null;
                    }
                    case WAITING: {
                        if (!this.isReadyForDebugging(client, printer)) continue block6;
                        return client;
                    }
                }
                if (this.myAttachToRunningProcess && this.isReadyForDebugging(client, printer)) {
                    return client;
                }
                printer.stderr("Waiting for application to start debug server");
            }
            this.sleep(1L, POLL_TIMEUNIT);
        }
        printer.stderr("Could not connect to remote process. Aborting debug session.");
        return null;
    }

    protected void sleep(long sleepFor, @NotNull TimeUnit unit) {
        Uninterruptibles.sleepUninterruptibly((long)sleepFor, (TimeUnit)unit);
    }

    public boolean isReadyForDebugging(@NotNull Client client, @NotNull ConsolePrinter printer) {
        return true;
    }

    @Nullable
    public abstract ProcessHandler launchDebugger(@NotNull LaunchInfo var1, @NotNull Client var2, @NotNull ProcessHandlerLaunchStatus var3, @NotNull ProcessHandlerConsolePrinter var4);
}

