/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.output.LogcatOutputSettings;
import com.android.tools.idea.run.AndroidDebugState;
import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.run.AndroidRemoteDebugProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.run.ApplicationLogListener;
import com.android.tools.idea.run.LaunchInfo;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.editor.AndroidDebugger;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.intellij.debugger.ui.DebuggerPanelsManager;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class ConnectJavaDebuggerTask
extends ConnectDebuggerTask {
    public ConnectJavaDebuggerTask(@NotNull Set<String> applicationIds, @NotNull AndroidDebugger debugger, @NotNull Project project, boolean monitorRemoteProcess, boolean attachToRunningProcess) {
        super(applicationIds, debugger, project, monitorRemoteProcess, attachToRunningProcess);
    }

    @NotNull
    protected ProcessHandler createDebugProcessHandler(@NotNull ProcessHandlerLaunchStatus launchStatus) {
        return new AndroidRemoteDebugProcessHandler(this.myProject, this.myMonitorRemoteProcess);
    }

    @NotNull
    protected RunContentDescriptor getDescriptor(@NotNull LaunchInfo currentLaunchInfo, @NotNull ProcessHandlerLaunchStatus launchStatus) {
        RunContentDescriptor descriptor = currentLaunchInfo.env.getContentToReuse();
        assert (descriptor != null) : "Expecting an existing descriptor that will be reused";
        return descriptor;
    }

    @NotNull
    protected ProcessHandler getOldProcessHandler(@NotNull LaunchInfo currentLaunchInfo, @NotNull ProcessHandlerLaunchStatus launchStatus) {
        ProcessHandler processHandler = this.getDescriptor(currentLaunchInfo, launchStatus).getProcessHandler();
        assert (processHandler != null);
        return processHandler;
    }

    @Override
    public ProcessHandler launchDebugger(@NotNull LaunchInfo currentLaunchInfo, @NotNull Client client, @NotNull ProcessHandlerLaunchStatus launchStatus, @NotNull ProcessHandlerConsolePrinter printer) {
        RunProfile runProfile;
        RunContentDescriptor debugDescriptor;
        String debugPort = Integer.toString(client.getDebuggerListenPort());
        final int pid = client.getClientData().getPid();
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format(Locale.US, "Attempting to connect debugger to port %1$s [client %2$d]", debugPort, pid));
        ProcessHandler processHandler = this.getOldProcessHandler(currentLaunchInfo, launchStatus);
        RunContentDescriptor descriptor = this.getDescriptor(currentLaunchInfo, launchStatus);
        RemoteConnection connection = new RemoteConnection(true, "localhost", debugPort, false);
        final ProcessHandler debugProcessHandler = this.createDebugProcessHandler(launchStatus);
        launchStatus.setProcessHandler(debugProcessHandler);
        printer.setProcessHandler(debugProcessHandler);
        processHandler.detachProcess();
        AndroidDebugState debugState = new AndroidDebugState(this.myProject, debugProcessHandler, connection, currentLaunchInfo.consoleProvider);
        try {
            ExecutionEnvironment debugEnv = new ExecutionEnvironmentBuilder(currentLaunchInfo.env).executor(currentLaunchInfo.executor).runner(currentLaunchInfo.runner).contentToReuse(descriptor).build();
            debugDescriptor = DebuggerPanelsManager.getInstance((Project)this.myProject).attachVirtualMachine(debugEnv, (RunProfileState)debugState, connection, false);
        }
        catch (ExecutionException e) {
            processHandler.notifyTextAvailable("ExecutionException: " + e.getMessage() + '.', ProcessOutputTypes.STDERR);
            return null;
        }
        if (debugDescriptor == null) {
            processHandler.notifyTextAvailable("Unable to connect debugger to Android application", ProcessOutputTypes.STDERR);
            return null;
        }
        AndroidProcessText oldText = AndroidProcessText.get(processHandler);
        if (oldText != null) {
            oldText.printTo(debugProcessHandler);
        }
        int uniqueId = (runProfile = currentLaunchInfo.env.getRunProfile()) instanceof RunConfigurationBase ? ((RunConfigurationBase)runProfile).getUniqueID() : -1;
        AndroidSessionInfo value = new AndroidSessionInfo(debugProcessHandler, debugDescriptor, uniqueId, currentLaunchInfo.executor.getId(), currentLaunchInfo.executor.getActionName(), InstantRunUtils.isInstantRunEnabled(currentLaunchInfo.env));
        debugProcessHandler.putUserData(AndroidSessionInfo.KEY, (Object)value);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT, (Object)client);
        debugProcessHandler.putUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL, (Object)client.getDevice().getVersion());
        final String pkgName = client.getClientData().getClientDescription();
        final IDevice device = client.getDevice();
        ConnectJavaDebuggerTask.captureLogcatOutput(client, debugProcessHandler);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private int myTerminationCount = 0;
            private boolean myWillBeDestroyed = true;

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processWillTerminate: " + pkgName + ", willBeDestroyed=" + willBeDestroyed);
                this.myWillBeDestroyed = willBeDestroyed;
                this.processTerminationCallback();
            }

            public void processTerminated(ProcessEvent event) {
                Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger-processTerminated: " + pkgName);
                this.processTerminationCallback();
            }

            private void processTerminationCallback() {
                ++this.myTerminationCount;
                if (this.myTerminationCount != 2) {
                    return;
                }
                debugProcessHandler.removeProcessListener((ProcessListener)this);
                Client currentClient = device.getClient(pkgName);
                if (currentClient != null && currentClient.getClientData().getPid() != pid) {
                    return;
                }
                if (this.myWillBeDestroyed) {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger terminating, so terminating process: " + pkgName);
                    try {
                        device.executeShellCommand("am force-stop " + pkgName, (IShellOutputReceiver)new NullOutputReceiver());
                    }
                    catch (Exception exception) {}
                } else {
                    Logger.getInstance(ConnectJavaDebuggerTask.class).info("Debugger detaching, leaving process alive: " + pkgName);
                }
            }
        });
        return debugProcessHandler;
    }

    private static void captureLogcatOutput(@NotNull Client client, final @NotNull ProcessHandler debugProcessHandler) {
        if (!StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get().booleanValue()) {
            return;
        }
        if (!LogcatOutputSettings.getInstance().isDebugOutputEnabled()) {
            return;
        }
        final IDevice device = client.getDevice();
        String pkgName = client.getClientData().getClientDescription();
        Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\")", device.getName()));
        final ApplicationLogListener logListener = new ApplicationLogListener(pkgName, client.getClientData().getPid()){
            private final String SIMPLE_FORMAT;
            private final AtomicBoolean myIsFirstMessage;
            {
                super(packageName, pid);
                this.SIMPLE_FORMAT = AndroidLogcatFormatter.createCustomFormat(false, false, false, true);
                this.myIsFirstMessage = new AtomicBoolean(true);
            }

            @Override
            @NotNull
            public String formatLogLine(@NotNull LogCatMessage line) {
                return AndroidLogcatFormatter.formatMessage(this.SIMPLE_FORMAT, line.getHeader(), line.getMessage());
            }

            @Override
            public void notifyTextAvailable(@NotNull String message, @NotNull Key key) {
                if (this.myIsFirstMessage.compareAndSet(true, false)) {
                    debugProcessHandler.notifyTextAvailable("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.\n", ProcessOutputTypes.STDOUT);
                }
                debugProcessHandler.notifyTextAvailable(message, key);
            }
        };
        AndroidLogcatService.getInstance().addListener(device, logListener, true);
        debugProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                Logger.getInstance(ConnectJavaDebuggerTask.class).info(String.format("captureLogcatOutput(\"%s\"): remove listener", device.getName()));
                AndroidLogcatService.getInstance().removeListener(device, logListener);
            }
        });
    }
}

