/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.FullApkInstaller;
import com.android.tools.idea.run.InstalledApkCache;
import com.android.tools.idea.run.InstalledPatchCache;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.ir.client.InstantRunClient;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployApkTask
implements LaunchTask {
    private static final Logger LOG = Logger.getInstance(DeployApkTask.class);
    private final Project myProject;
    private final Collection<ApkInfo> myApks;
    private final LaunchOptions myLaunchOptions;
    private final InstantRunContext myInstantRunContext;

    public DeployApkTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @NotNull Collection<ApkInfo> apks) {
        this(project, launchOptions, apks, null);
    }

    public DeployApkTask(@NotNull Project project, @NotNull LaunchOptions launchOptions, @NotNull Collection<ApkInfo> apks, @Nullable InstantRunContext instantRunContext) {
        this.myProject = project;
        this.myLaunchOptions = launchOptions;
        this.myApks = apks;
        this.myInstantRunContext = instantRunContext;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Installing APK";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        FullApkInstaller installer = new FullApkInstaller(this.myProject, this.myLaunchOptions, (InstalledApkCache)ServiceManager.getService(InstalledApkCache.class), printer);
        for (ApkInfo apk : this.myApks) {
            if (!apk.getFile().exists()) {
                String message = "The APK file " + apk.getFile().getPath() + " does not exist on disk.";
                printer.stderr(message);
                LOG.warn(message);
                return false;
            }
            String pkgName = apk.getApplicationId();
            if (!installer.uploadAndInstallApk(device, pkgName, apk.getFile(), launchStatus)) {
                return false;
            }
            if (this.myInstantRunContext != null) continue;
            try {
                InstantRunClient.transferBuildIdToDevice((IDevice)device, (String)"", (String)pkgName, null);
            }
            catch (Throwable throwable) {}
        }
        if (this.myInstantRunContext == null) {
            InstantRunStatsService.get(this.myProject).notifyNonInstantRunDeployType(device);
        } else {
            InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.FULLAPK, this.myInstantRunContext, device);
        }
        DeployApkTask.trackInstallation(device);
        return true;
    }

    public static void cacheManifestInstallationData(@NotNull IDevice device, @NotNull InstantRunContext context) {
        InstalledPatchCache patchCache = (InstalledPatchCache)ServiceManager.getService(InstalledPatchCache.class);
        patchCache.setInstalledManifestResourcesHash(device, context.getApplicationId(), context.getManifestResourcesHash());
    }

    private static void trackInstallation(@NotNull IDevice device) {
        if (!UsageTracker.getInstance().getAnalyticsSettings().hasOptedIn()) {
            return;
        }
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.DEPLOYMENT).setKind(AndroidStudioEvent.EventKind.DEPLOYMENT_APK).setDeviceInfo(AndroidStudioUsageTracker.deviceToDeviceInfo(device)));
    }
}

