/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.instantapp.run.InstantAppRunException;
import com.android.instantapp.run.InstantAppSideLoader;
import com.android.instantapp.run.RunListener;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployInstantAppTask
implements LaunchTask {
    @NotNull
    private final Collection<ApkInfo> myPackages;

    public DeployInstantAppTask(@NotNull Collection<ApkInfo> packages) {
        this.myPackages = packages;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Uploading and registering Instant App";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (this.myPackages.size() != 1) {
            printer.stderr("Zip file not found or not unique.");
            return false;
        }
        ApkInfo apkInfo = this.myPackages.iterator().next();
        File zipFile = apkInfo.getFile();
        String appId = apkInfo.getApplicationId();
        if (!zipFile.exists()) {
            printer.stderr("The file " + zipFile.getPath() + " does not exist on disk.");
            return false;
        }
        if (!zipFile.getName().endsWith(".zip")) {
            printer.stderr("The file " + zipFile.getPath() + " is not a zip file.");
            return false;
        }
        IDevice onlineDevice = DeployInstantAppTask.getCorrespondingOnlineDevice(device);
        if (onlineDevice == null) {
            printer.stderr("Device \"" + device.getSerialNumber() + "\" is offline.");
            return false;
        }
        return this.install(onlineDevice, launchStatus, printer, appId, zipFile);
    }

    @VisibleForTesting
    boolean install(@NotNull IDevice device, final @NotNull LaunchStatus launchStatus, final @NotNull ConsolePrinter printer, @NotNull String appId, @NotNull File zipFile) {
        RunListener listener = new RunListener(){

            public void printMessage(@NotNull String message) {
                printer.stdout(message);
            }

            public void logMessage(@NotNull String message, @Nullable InstantAppRunException e) {
                if (e == null) {
                    DeployInstantAppTask.this.getLogger().info(message);
                } else {
                    DeployInstantAppTask.this.getLogger().warn(message, (Throwable)e);
                }
            }

            public boolean isCancelled() {
                return launchStatus.isLaunchTerminated();
            }
        };
        InstantAppSideLoader installer = InstantApps.isPostO(device) ? new InstantAppSideLoader(appId, DeployInstantAppTask.extractApks(zipFile), listener) : new InstantAppSideLoader(appId, zipFile, listener);
        AtomicBoolean tryAgain = new AtomicBoolean(true);
        AtomicBoolean result = new AtomicBoolean(false);
        while (tryAgain.get()) {
            try {
                installer.install(device);
                tryAgain.set(false);
                result.set(true);
            }
            catch (InstantAppRunException e) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    int choice = Messages.showYesNoDialog((String)("Side loading failed with message: " + e.getMessage() + " Do you want to retry?"), (String)"Instant Apps", null);
                    if (choice != 0) {
                        if (e.getErrorType() != InstantAppRunException.ErrorType.NO_GOOGLE_ACCOUNT && e.getErrorType() != InstantAppRunException.ErrorType.CANCELLED) {
                            this.getLogger().error((Throwable)e);
                        }
                        tryAgain.set(false);
                        result.set(false);
                    }
                });
            }
        }
        return result.get();
    }

    @NotNull
    private static List<File> extractApks(@NotNull File zip) {
        File tempDir = Files.createTempDir();
        try {
            ZipUtil.extract((File)zip, (File)tempDir, null);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        File[] apks = tempDir.listFiles();
        return apks == null ? Collections.emptyList() : Arrays.asList(apks);
    }

    @Nullable
    private static IDevice getCorrespondingOnlineDevice(@NotNull IDevice device) {
        if (device.isOnline()) {
            return device;
        }
        List<IDevice> devices = DeviceSelectionUtils.getAllCompatibleDevices((Predicate<IDevice>)((Predicate)input -> input != null && input.getSerialNumber().compareTo(device.getSerialNumber()) == 0));
        return devices.size() == 1 ? devices.get(0) : null;
    }

    @NotNull
    private Logger getLogger() {
        return Logger.getInstance(this.getClass());
    }
}

