/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.ir.client.InstantRunClient;
import com.android.tools.ir.client.InstantRunPushFailedException;
import com.android.tools.ir.client.UpdateMode;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class HotSwapTask
implements LaunchTask {
    private final Project myProject;
    private final InstantRunContext myInstantRunContext;
    private final boolean myRestartActivity;

    public HotSwapTask(@NotNull Project project, @NotNull InstantRunContext context, boolean restartActivity) {
        this.myProject = project;
        this.myInstantRunContext = context;
        this.myRestartActivity = restartActivity;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Hotswapping changes";
    }

    @Override
    public int getDuration() {
        return 8;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        InstantRunManager manager = InstantRunManager.get(this.myProject);
        try {
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(this.myInstantRunContext);
            if (instantRunClient == null) {
                return HotSwapTask.terminateLaunch(launchStatus, "Unable to connect to application. Press Run or Debug to rebuild and install the app.");
            }
            UpdateMode updateMode = manager.pushArtifacts(device, this.myInstantRunContext, this.myRestartActivity ? UpdateMode.WARM_SWAP : UpdateMode.HOT_SWAP);
            printer.stdout("Hot swapped changes, activity " + (updateMode == UpdateMode.HOT_SWAP ? "not restarted" : "restarted"));
        }
        catch (InstantRunPushFailedException | IOException e) {
            return HotSwapTask.terminateLaunch(launchStatus, "Error installing hot swap patches: " + e);
        }
        InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.HOTSWAP, this.myInstantRunContext, device);
        return true;
    }

    private static boolean terminateLaunch(LaunchStatus launchStatus, String msg) {
        launchStatus.terminateLaunch(msg);
        InstantRunManager.LOG.info("Terminating launch: " + msg);
        return false;
    }
}

