/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class KillTask
implements LaunchTask {
    private final Project myProject;
    private final InstantRunContext myContext;

    public KillTask(@NotNull Project project, @NotNull InstantRunContext context) {
        this.myProject = project;
        this.myContext = context;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Restart application";
    }

    @Override
    public int getDuration() {
        return 1;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        try {
            NullOutputReceiver receiver = new NullOutputReceiver();
            device.executeShellCommand("am force-stop " + this.myContext.getApplicationId(), (IShellOutputReceiver)receiver);
            return true;
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            launchStatus.terminateLaunch("Error stopping application: " + e);
            InstantRunManager.LOG.warn("Failed stopping application: ", e);
            e.printStackTrace();
            return false;
        }
    }
}

