/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.tasks;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.InstallException;
import com.android.tools.idea.fd.DeployType;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunStatsService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.InstallResult;
import com.android.tools.idea.run.RetryingInstaller;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.ir.client.InstantRunArtifact;
import com.android.tools.ir.client.InstantRunArtifactType;
import com.android.tools.ir.client.InstantRunBuildInfo;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class SplitApkDeployTask
implements LaunchTask {
    private static final Pattern DEVICE_NOT_FOUND_ERROR = Pattern.compile("device '.*' not found");
    private final Project myProject;
    private final InstantRunContext myInstantRunContext;
    private final boolean myDontKill;

    public SplitApkDeployTask(Project project, InstantRunContext context) {
        this(project, context, false);
    }

    public SplitApkDeployTask(Project project, InstantRunContext context, boolean dontKill) {
        this.myProject = project;
        this.myInstantRunContext = context;
        this.myDontKill = dontKill;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Installing APKs";
    }

    @Override
    public int getDuration() {
        return 20;
    }

    @Override
    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        InstantRunBuildInfo buildInfo = this.myInstantRunContext.getInstantRunBuildInfo();
        assert (buildInfo != null);
        ArrayList installOptions = Lists.newArrayList();
        installOptions.add("-t");
        if (buildInfo.isPatchBuild()) {
            installOptions.add("-p");
            installOptions.add(this.myInstantRunContext.getApplicationId());
        }
        if (this.myDontKill) {
            installOptions.add("--dont-kill");
        }
        List artifacts = buildInfo.getArtifacts();
        ArrayList apks = Lists.newArrayListWithExpectedSize((int)artifacts.size());
        for (InstantRunArtifact artifact : artifacts) {
            if (artifact.type != InstantRunArtifactType.SPLIT_MAIN && artifact.type != InstantRunArtifactType.SPLIT) continue;
            apks.add(artifact.file);
        }
        SplitApkInstaller installer = new SplitApkInstaller(printer, apks, installOptions);
        RetryingInstaller retryingInstaller = new RetryingInstaller(this.myProject, device, installer, this.myInstantRunContext.getApplicationId(), printer, launchStatus);
        boolean status = retryingInstaller.install();
        if (status) {
            printer.stdout("Split APKs installed");
        }
        assert (this.myInstantRunContext.getBuildSelection() != null);
        InstantRunStatsService.get(this.myProject).notifyDeployType(DeployType.SPLITAPK, this.myInstantRunContext, device);
        return status;
    }

    private static final class SplitApkInstaller
    implements RetryingInstaller.Installer {
        private final ConsolePrinter myPrinter;
        private final List<File> myApks;
        private final List<String> myInstallOptions;

        public SplitApkInstaller(@NotNull ConsolePrinter printer, @NotNull List<File> apks, @NotNull List<String> installOptions) {
            this.myPrinter = printer;
            this.myApks = apks;
            this.myInstallOptions = installOptions;
        }

        @Override
        @NotNull
        public InstallResult installApp(@NotNull IDevice device, @NotNull LaunchStatus launchStatus) {
            String cmd = SplitApkInstaller.getAdbInstallCommand(this.myApks, this.myInstallOptions);
            try {
                this.myPrinter.stdout(cmd);
                InstantRunManager.LOG.info(cmd);
                device.installPackages(this.myApks, true, this.myInstallOptions, 5L, TimeUnit.MINUTES);
                return new InstallResult(InstallResult.FailureCode.NO_ERROR, null, null);
            }
            catch (InstallException e) {
                InstallResult.FailureCode failureCode = InstallResult.FailureCode.UNTYPED_ERROR;
                if (e.getMessage() != null && DEVICE_NOT_FOUND_ERROR.matcher(e.getMessage()).matches()) {
                    failureCode = InstallResult.FailureCode.DEVICE_NOT_FOUND;
                }
                return new InstallResult(failureCode, e.getMessage(), null);
            }
        }

        @NotNull
        private static String getAdbInstallCommand(@NotNull List<File> apks, @NotNull List<String> installOptions) {
            StringBuilder sb = new StringBuilder();
            sb.append("$ adb install-multiple -r ");
            if (!installOptions.isEmpty()) {
                sb.append(Joiner.on((char)' ').join(installOptions));
                sb.append(' ');
            }
            for (File f : apks) {
                sb.append(f.getPath());
                sb.append(' ');
            }
            return sb.toString();
        }
    }
}

