/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata;

import com.android.tools.idea.res.SampleDataResourceRepository;
import com.android.tools.idea.sampledata.datasource.CombinerDataSource;
import com.android.tools.idea.sampledata.datasource.HardcodedContent;
import com.android.tools.idea.sampledata.datasource.LoremIpsumGenerator;
import com.android.tools.idea.sampledata.datasource.NumberGenerator;
import com.android.tools.idea.sampledata.datasource.ResourceContent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddSampleDataDialog
extends DialogWrapper {
    private static Logger LOG = Logger.getInstance(AddSampleDataDialog.class);
    private VirtualFile myCreatedFile;
    private final AndroidFacet myFacet;
    private JBList<SampleDataSource> mySourcesList;
    private JPanel myPanel;

    protected AddSampleDataDialog(@NotNull AndroidFacet facet) {
        super(facet.getModule().getProject());
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.mySourcesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index == 0) {
                    this.setBorder(JBUI.Borders.customLine((Color)JBColor.DARK_GRAY, (int)0, (int)0, (int)1, (int)0));
                    this.setFont(this.getFont().deriveFont(2));
                }
                return this;
            }
        });
        DefaultListModel<SampleDataSource> model = new DefaultListModel<SampleDataSource>();
        ClassLoader loader = AddSampleDataDialog.class.getClassLoader();
        model.addElement(new SampleDataSource("New empty file...", "sample", new HardcodedContent("Replace this content with the sample data you want to use")));
        model.addElement(new SampleDataSource("Full names", "full_names", new CombinerDataSource(loader.getResourceAsStream("sampleData/names.txt"), loader.getResourceAsStream("sampleData/surnames.txt"))));
        model.addElement(new SampleDataSource("First names", "names", ResourceContent.fromInputStream(loader.getResourceAsStream("sampleData/names.txt"))));
        model.addElement(new SampleDataSource("Last names", "surnames", ResourceContent.fromInputStream(loader.getResourceAsStream("sampleData/surnames.txt"))));
        model.addElement(new SampleDataSource("Cities of the world", "cities", ResourceContent.fromInputStream(loader.getResourceAsStream("sampleData/cities.txt"))));
        model.addElement(new SampleDataSource("US Postcode", "postcodes", new NumberGenerator("%05d", 20000, 99999)));
        model.addElement(new SampleDataSource("US Phone numbers", "phones", new NumberGenerator("555-%04d", 0, 9999)));
        model.addElement(new SampleDataSource("Lorem Ipsum", "lorem", new LoremIpsumGenerator(false)));
        this.mySourcesList.setModel(model);
        this.setTitle("Add Sample Data File");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
        int selectedIndex = this.mySourcesList.getSelectedIndex();
        if (selectedIndex == -1) {
            return;
        }
        final SampleDataSource dataSource = (SampleDataSource)this.mySourcesList.getModel().getElementAt(selectedIndex);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myFacet.getModule().getProject(), "Adding Sample Data File", false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                AddSampleDataDialog.this.doDataGeneration(this.myProject, dataSource);
            }
        });
    }

    private void doDataGeneration(@NotNull Project project, @NotNull SampleDataSource dataSource) {
        VirtualFile sampleDataDir;
        VirtualFile contentRoot = AndroidRootUtil.getMainContentRoot(this.myFacet);
        if (contentRoot == null) {
            return;
        }
        String rootFileName = dataSource.myFileNameRoot;
        try {
            sampleDataDir = SampleDataResourceRepository.getSampleDataDir(this.myFacet, true);
        }
        catch (IOException e) {
            LOG.error("Unable to find sample data directory", (Throwable)e);
            return;
        }
        this.myCreatedFile = (VirtualFile)WriteCommandAction.runWriteCommandAction((Project)this.myFacet.getModule().getProject(), () -> {
            VirtualFile newFile = null;
            try {
                String fileName = rootFileName;
                int i = 1;
                while (sampleDataDir.findChild(fileName) != null || i > 50) {
                    fileName = rootFileName + i++;
                }
                newFile = sampleDataDir.createChildData((Object)this, fileName);
                try (OutputStream outputStream = newFile.getOutputStream((Object)this);){
                    Exception e = (Exception)dataSource.myRunnable.apply(outputStream);
                    if (e != null) {
                        LOG.error("Unable to create sample data file", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Unable to create sample data file", (Throwable)e);
            }
            return newFile;
        });
        if (this.myCreatedFile != null) {
            OpenFileDescriptor fileDesc = new OpenFileDescriptor(project, this.myCreatedFile);
            ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)project).openTextEditor(fileDesc, true));
        }
    }

    @Nullable
    public String getCreatedFileName() {
        return this.myCreatedFile != null ? this.myCreatedFile.getName() : null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySourcesList = jBList = new JBList();
        jPanel.add((Component)jBList, new GridConstraints(0, 0, 1, 3, 0, 3, 6, 6, new Dimension(300, 300), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private static class SampleDataSource {
        private final Function<OutputStream, Exception> myRunnable;
        private final String myDisplayName;
        private final String myFileNameRoot;

        SampleDataSource(@NotNull String displayName, @NotNull String fileNameRoot, @NotNull Function<OutputStream, Exception> runnable) {
            this.myDisplayName = displayName;
            this.myFileNameRoot = fileNameRoot;
            this.myRunnable = runnable;
        }

        public String toString() {
            return this.myDisplayName;
        }
    }
}

