/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sampledata.datasource;

import com.google.common.base.Charsets;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import libcore.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceContent
implements Function<OutputStream, Exception> {
    private static final Logger LOG = Logger.getInstance(ResourceContent.class);
    private static final String[] LIB_CUSTOM_PATHS = new String[]{"/plugins/android/lib/sampleData", "/../adt/idea/android/lib/sampleData", "/community/android/android/lib/sampleData"};
    byte[] myContent;

    private ResourceContent(@NotNull byte[] content) {
        this.myContent = content;
    }

    @Nullable
    private static File getSampleDataBaseDir() {
        String homePath = FileUtil.toSystemIndependentName((String)PathManager.getHomePath());
        StringBuilder notFoundPaths = new StringBuilder();
        for (String path : LIB_CUSTOM_PATHS) {
            String jarPath = homePath + path;
            VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath));
            if (rootDir != null) {
                File rootFile = VfsUtilCore.virtualToIoFile((VirtualFile)rootDir);
                if (!rootFile.exists()) continue;
                LOG.debug("Sample data base dir found at " + jarPath);
                return rootFile;
            }
            notFoundPaths.append(jarPath).append('\n');
        }
        LOG.warn("Unable to sampleData in paths:\n" + notFoundPaths.toString());
        return null;
    }

    @NotNull
    public static ResourceContent fromDirectory(@NotNull String relativePath) {
        File baseDir = ResourceContent.getSampleDataBaseDir();
        File sampleDataPath = baseDir != null ? new File(baseDir, relativePath) : null;
        File[] files = sampleDataPath != null && sampleDataPath.isDirectory() ? sampleDataPath.listFiles() : null;
        StringBuilder content = new StringBuilder();
        if (files != null) {
            for (File file : files) {
                content.append(file.getAbsolutePath()).append('\n');
            }
        }
        return new ResourceContent(content.toString().getBytes(Charsets.UTF_8));
    }

    @NotNull
    public static ResourceContent fromInputStream(@NotNull InputStream stream) {
        byte[] content;
        try {
            content = Streams.readFully((InputStream)stream);
        }
        catch (IOException e) {
            content = new byte[]{};
        }
        return new ResourceContent(content);
    }

    @Override
    public Exception apply(OutputStream stream) {
        try {
            stream.write(this.myContent);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }
}

