/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressIndicatorAdapter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.jetbrains.annotations.NotNull;

public class StudioDownloader
implements Downloader {
    public InputStream downloadAndStream(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        Path file = this.downloadFully(url, indicator);
        if (file == null) {
            return null;
        }
        return Files.newInputStream(file, StandardOpenOption.DELETE_ON_CLOSE);
    }

    public void downloadFully(@NotNull URL url, @NotNull File target, String checksum, @NotNull ProgressIndicator indicator) throws IOException {
        if (target.exists() && checksum != null && checksum.equals(Downloader.hash((InputStream)new BufferedInputStream(new FileInputStream(target)), (long)target.length(), (ProgressIndicator)indicator))) {
            return;
        }
        indicator.logInfo("Downloading " + url);
        indicator.setText("Downloading...");
        indicator.setSecondaryText(url.toString());
        HttpRequests.request((String)url.toExternalForm()).productNameAsUserAgent().saveToFile(target, (com.intellij.openapi.progress.ProgressIndicator)new StudioProgressIndicatorAdapter(indicator, null));
    }

    public Path downloadFully(@NotNull URL url, @NotNull ProgressIndicator indicator) throws IOException {
        String suffix = url.getPath();
        suffix = suffix.substring(suffix.lastIndexOf(47) + 1);
        File tempFile = FileUtil.createTempFile((String)"StudioDownloader", (String)suffix, (boolean)true);
        tempFile.deleteOnExit();
        this.downloadFully(url, tempFile, null, indicator);
        return tempFile.toPath();
    }
}

