/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VersionCheck {
    private static final Logger LOG = Logger.getInstance(VersionCheck.class);
    public static final Revision MIN_TOOLS_REV = new Revision(24, 0, 2, 0);
    private static final Pattern SOURCE_PROPERTY_PATTERN = Pattern.compile("^Pkg.Revision=(.*)$");

    private VersionCheck() {
    }

    public static boolean isCompatibleVersion(@NotNull File sdkDir) {
        if (!sdkDir.isDirectory()) {
            return false;
        }
        return VersionCheck.isCompatibleVersion(sdkDir.getAbsolutePath());
    }

    public static boolean isCompatibleVersion(@Nullable String sdkPath) {
        if (sdkPath == null) {
            return false;
        }
        return VersionCheck.checkVersion(sdkPath).isCompatibleVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static VersionCheckResult checkVersion(@NotNull String sdkPath) {
        Revision toolsRevision;
        block13: {
            String line;
            File toolsDir = new File(sdkPath, SdkConstants.OS_SDK_TOOLS_FOLDER);
            toolsRevision = new Revision(Integer.MAX_VALUE);
            BufferedReader reader = null;
            File sourceProperties2333333332 = new File(toolsDir, "source.properties");
            reader = new BufferedReader(new FileReader(sourceProperties2333333332));
            while ((line = reader.readLine()) != null) {
                Matcher m = SOURCE_PROPERTY_PATTERN.matcher(line);
                if (!m.matches()) continue;
                try {
                    toolsRevision = Revision.parseRevision((String)m.group(1));
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException sourceProperties2333333332) {}
            break block13;
            catch (IOException e) {
                try {
                    String msg = String.format("Failed to read file: '%1$s' for Android SDK at '%2$s'", "source.properties", sdkPath);
                    LOG.info(msg, (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        Closeables.close(reader, (boolean)true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
        return new VersionCheckResult(toolsRevision);
    }

    public static class VersionCheckResult {
        @NotNull
        private final Revision myRevision;
        private final boolean myCompatibleVersion;

        VersionCheckResult(@NotNull Revision revision) {
            this.myRevision = revision;
            this.myCompatibleVersion = VersionCheckResult.isCompatible(revision);
        }

        private static boolean isCompatible(@NotNull Revision revision) {
            if (revision.getMajor() == Integer.MAX_VALUE) {
                return false;
            }
            return revision.compareTo(MIN_TOOLS_REV, Revision.PreviewComparison.IGNORE) >= 0;
        }

        @NotNull
        public Revision getRevision() {
            return this.myRevision;
        }

        public boolean isCompatibleVersion() {
            return this.myCompatibleVersion;
        }
    }
}

