/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install;

import com.android.repository.api.InstallerFactory;
import com.android.repository.impl.installer.BasicInstallerFactory;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.sdk.install.StudioSdkInstallListenerFactory;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import org.jetbrains.annotations.NotNull;

public final class StudioSdkInstallerUtil {
    @NotNull
    public static InstallerFactory createInstallerFactory(@NotNull AndroidSdkHandler sdkHandler) {
        Object factory;
        BasicInstallerFactory basicFactory = new BasicInstallerFactory();
        if (Boolean.getBoolean("sdk.patches.disable")) {
            factory = basicFactory;
        } else {
            factory = new PatchInstallerFactory();
            factory.setFallbackFactory((InstallerFactory)basicFactory);
        }
        factory.setListenerFactory((InstallerFactory.StatusChangeListenerFactory)new StudioSdkInstallListenerFactory(sdkHandler));
        return factory;
    }

    private StudioSdkInstallerUtil() {
    }
}

