/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.installer.AbstractInstaller;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FullInstaller
extends AbstractInstaller
implements PatchOperation {
    private static final String UNZIP_DIR_FN = "unzip";
    private LocalPackage myExisting;
    private LocalPackage myPatcher;
    private File myUnzippedPackage;
    private File myGeneratedPatch;

    public FullInstaller(@Nullable LocalPackage existing, @NotNull RemotePackage p, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        super(p, mgr, downloader, fop);
        this.myExisting = existing;
        this.myPatcher = PatchInstallerUtil.getDependantPatcher(this.getPackage(), this.getRepoManager());
        if (this.myPatcher == null) {
            this.myPatcher = PatchInstallerUtil.getLatestPatcher(this.getRepoManager());
        }
    }

    protected boolean doComplete(@Nullable File installTemp, @NotNull ProgressIndicator progress) {
        if (this.myPatcher == null) {
            return false;
        }
        return PatchInstallerUtil.installPatch(this, this.myGeneratedPatch, this.mFop, progress);
    }

    protected boolean doPrepare(@NotNull File installTempPath, @NotNull ProgressIndicator progress) {
        if (!this.downloadAndUnzip(installTempPath, this.getDownloader(), progress.createSubProgress(0.5))) {
            progress.setFraction(1.0);
            return false;
        }
        this.myUnzippedPackage = new File(installTempPath, UNZIP_DIR_FN);
        File[] children = this.mFop.listFiles(this.myUnzippedPackage);
        if (children.length == 1) {
            this.myUnzippedPackage = children[0];
        }
        this.myGeneratedPatch = PatchInstallerUtil.generatePatch(this, installTempPath, this.mFop, progress.createSubProgress(1.0));
        progress.setFraction(1.0);
        return this.myGeneratedPatch != null;
    }

    private boolean downloadAndUnzip(@NotNull File installTempPath, @NotNull Downloader downloader, @NotNull ProgressIndicator progress) {
        URL url = InstallerUtil.resolveCompleteArchiveUrl((RemotePackage)this.getPackage(), (ProgressIndicator)progress);
        if (url == null) {
            progress.logWarning("No compatible archive found!");
            return false;
        }
        Archive archive = this.getPackage().getArchive();
        assert (archive != null);
        try {
            File downloadLocation = new File(installTempPath, url.getFile());
            String checksum = archive.getComplete().getChecksum();
            downloader.downloadFully(url, downloadLocation, checksum, progress.createSubProgress(0.5));
            progress.setFraction(0.5);
            if (progress.isCanceled()) {
                progress.setFraction(1.0);
                return false;
            }
            if (!this.mFop.exists(downloadLocation)) {
                progress.setFraction(1.0);
                progress.logWarning("Failed to download package!");
                return false;
            }
            File unzip = new File(installTempPath, UNZIP_DIR_FN);
            this.mFop.mkdirs(unzip);
            InstallerUtil.unzip((File)downloadLocation, (File)unzip, (FileOp)this.mFop, (long)archive.getComplete().getSize(), (ProgressIndicator)progress.createSubProgress(1.0));
            progress.setFraction(1.0);
            if (progress.isCanceled()) {
                return false;
            }
            this.mFop.delete(downloadLocation);
            return true;
        }
        catch (IOException e) {
            StringBuilder message = new StringBuilder("An error occurred while preparing SDK package ").append(this.getPackage().getDisplayName());
            String exceptionMessage = e.getMessage();
            if (exceptionMessage != null && !exceptionMessage.isEmpty()) {
                message.append(": ").append(exceptionMessage);
            } else {
                message.append(".");
            }
            progress.logWarning(message.toString(), (Throwable)e);
            progress.setFraction(1.0);
            return false;
        }
    }

    @Override
    @Nullable
    public LocalPackage getExisting() {
        return this.myExisting;
    }

    @Override
    @NotNull
    public LocalPackage getPatcher(@NotNull ProgressIndicator progressIndicator) {
        return this.myPatcher;
    }

    @Override
    @NotNull
    public File getNewFilesRoot() {
        return this.myUnzippedPackage;
    }

    @Override
    @NotNull
    public String getNewVersionName() {
        return this.getPackage().getDisplayName() + " Version " + this.getPackage().getVersion();
    }
}

