/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Uninstaller;
import com.android.repository.impl.installer.AbstractInstallerFactory;
import com.android.repository.impl.meta.Archive;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileUtilKt;
import com.android.tools.idea.sdk.install.patch.FullInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstaller;
import com.android.tools.idea.sdk.install.patch.PatchInstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.android.tools.idea.sdk.install.patch.PatchUninstaller;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallerFactory
extends AbstractInstallerFactory {
    private static final String KNOWN_GOOD_VERSION = "patcher;v4";
    private static final long PSEUDO_PATCH_CUTOFF = 0x6400000L;
    private final PatchRunner.Factory myPatchRunnerFactory;

    public PatchInstallerFactory() {
        this(new PatchRunner.DefaultFactory());
    }

    PatchInstallerFactory(@NotNull PatchRunner.Factory runnerFactory) {
        this.myPatchRunnerFactory = runnerFactory;
    }

    @NotNull
    protected Installer doCreateInstaller(@NotNull RemotePackage remote, @NotNull RepoManager mgr, @NotNull Downloader downloader, @NotNull FileOp fop) {
        LocalPackage local = (LocalPackage)mgr.getPackages().getLocalPackages().get(remote.getPath());
        if (PatchInstallerFactory.hasPatch(local, remote)) {
            return new PatchInstaller(local, remote, downloader, mgr, fop);
        }
        return new FullInstaller(local, remote, mgr, downloader, fop);
    }

    private static boolean hasPatch(@Nullable LocalPackage local, @NotNull RemotePackage remote) {
        Archive archive = remote.getArchive();
        assert (archive != null);
        return local != null && archive.getPatch(local.getVersion()) != null;
    }

    @NotNull
    protected Uninstaller doCreateUninstaller(@NotNull LocalPackage local, @NotNull RepoManager mgr, @NotNull FileOp fop) {
        return new PatchUninstaller(local, mgr, fop);
    }

    protected boolean canHandlePackage(@NotNull RepoPackage p, @NotNull RepoManager manager, @NotNull FileOp fop) {
        LocalPackage patcher;
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(PatchInstallerFactory.class);
        if (p instanceof LocalPackage) {
            if (fop.isWindows()) {
                try {
                    if (FileUtilKt.recursiveSize((Path)fop.toPath(((LocalPackage)p).getLocation())) >= 0x6400000L) {
                        return false;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LocalPackage latestPatcher = PatchInstallerUtil.getLatestPatcher(manager);
                return latestPatcher != null && !latestPatcher.equals(p);
            }
            return false;
        }
        LocalPackage local = (LocalPackage)manager.getPackages().getLocalPackages().get(p.getPath());
        RemotePackage remote = (RemotePackage)p;
        if (local == null || !fop.isWindows() && !PatchInstallerFactory.hasPatch(local, remote)) {
            return false;
        }
        if (PatchInstallerFactory.hasPatch(local, remote)) {
            patcher = PatchInstallerUtil.getDependantPatcher((RemotePackage)p, manager);
            if (patcher != null && this.myPatchRunnerFactory.getPatchRunner(patcher, (ProgressIndicator)progress, fop) != null) {
                return true;
            }
            if (PatchInstallerUtil.getInProgressDependantPatcherInstall((RemotePackage)p, manager) != null) {
                return true;
            }
            if (!fop.isWindows()) {
                return false;
            }
        }
        if (((RemotePackage)p).getArchive().getComplete().getSize() >= 0x6400000L) {
            return false;
        }
        patcher = PatchInstallerUtil.getLatestPatcher(manager);
        return patcher != null && PatchInstallerUtil.comparePatcherPaths(patcher.getPath(), KNOWN_GOOD_VERSION) >= 0;
    }
}

