/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.install.patch;

import com.android.repository.api.Dependency;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.io.FileOp;
import com.android.repository.util.InstallerUtil;
import com.android.tools.idea.sdk.install.patch.PatchInstallerFactory;
import com.android.tools.idea.sdk.install.patch.PatchOperation;
import com.android.tools.idea.sdk.install.patch.PatchRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatchInstallerUtil {
    public static final String PATCHER_PATH_PREFIX = "patcher";
    static final String PATCHES_DIR_NAME = ".patches";
    static final String PATCH_JAR_FN = "patch.jar";
    static final String PATCH_DIR_PREFIX = PatchInstallerFactory.class.getSimpleName();
    private static final String PATCH_ZIP_FN = "patch-file.zip";

    @Nullable
    static LocalPackage getDependantPatcher(@NotNull RemotePackage remote, @NotNull RepoManager mgr) {
        for (Dependency d : remote.getAllDependencies()) {
            LocalPackage patcher;
            if (!d.getPath().startsWith("patcher;") || (patcher = (LocalPackage)mgr.getPackages().getLocalPackages().get(d.getPath())) == null) continue;
            return patcher;
        }
        return null;
    }

    @Nullable
    static LocalPackage getLatestPatcher(@NotNull RepoManager mgr) {
        LocalPackage patcher = null;
        for (LocalPackage p : mgr.getPackages().getLocalPackagesForPrefix(PATCHER_PATH_PREFIX)) {
            if (patcher != null && PatchInstallerUtil.comparePatcherPaths(p.getPath(), patcher.getPath()) <= 0) continue;
            patcher = p;
        }
        return patcher;
    }

    static int comparePatcherPaths(@NotNull String path1, @NotNull String path2) {
        int v1 = -1;
        int v2 = -1;
        try {
            v1 = Integer.parseInt(path1.substring(path1.lastIndexOf(118) + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            v2 = Integer.parseInt(path2.substring(path2.lastIndexOf(118) + 1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Integer.compare(v1, v2);
    }

    static boolean installPatch(@NotNull PatchOperation op, @Nullable File patch, @NotNull FileOp fop, @NotNull ProgressIndicator progress) {
        boolean result;
        if (patch == null) {
            return false;
        }
        LocalPackage patcherPackage = op.getPatcher(progress);
        if (patcherPackage == null) {
            return false;
        }
        PatchRunner patcher = new PatchRunner.DefaultFactory().getPatchRunner(patcherPackage, progress, fop);
        if (patcher == null) {
            return false;
        }
        fop.deleteFileOrFolder(new File(op.getLocation(progress), ".installer"));
        File tempPath = patch.getParentFile();
        File existingPackageXml = new File(op.getLocation(progress), "package.xml");
        File tempPackageXml = new File(tempPath, "package.xml");
        fop.renameTo(existingPackageXml, tempPackageXml);
        try {
            result = patcher.run(op.getLocation(progress), patch, progress);
        }
        catch (PatchRunner.RestartRequiredException e) {
            PatchInstallerUtil.askAboutRestart(patcher, op, patch, fop, progress);
            result = false;
        }
        if (!result) {
            fop.renameTo(tempPackageXml, existingPackageXml);
            return false;
        }
        progress.logInfo("Done");
        return true;
    }

    private static void askAboutRestart(@NotNull PatchRunner patchRunner, @NotNull PatchOperation op, @NotNull File patchFile, @NotNull FileOp fop, @NotNull ProgressIndicator progress) {
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        application.invokeLater(() -> {
            ApplicationNamesInfo names = ApplicationNamesInfo.getInstance();
            boolean restartable = application.isRestartCapable();
            String[] options = restartable ? new String[]{"Cancel", "Restart Later", "Restart Now"} : new String[]{"Cancel", String.format("Exit %s", names.getProductName())};
            String message = op.getExisting() != null ? String.format("%1$s is currently in use by %2$s and cannot be updated. Please restart to complete installation.", op.getExisting().getDisplayName(), names.getFullProductName()) : String.format("Some files in the destination are currently in use by %1$s. Please restart to complete installation.", names.getFullProductName());
            int result = Messages.showDialog((Project)null, (String)message, (String)"Restart Required", (String[])options, (int)(options.length - 1), (Icon)AllIcons.General.QuestionDialog);
            if (result == 0) {
                progress.logInfo("Cancelled");
            } else if (PatchInstallerUtil.setupPatchDir(patchFile, patchRunner.getPatcherJar(), op.getPackage(), op.getRepoManager(), fop, progress)) {
                if (result == 1 && restartable) {
                    progress.logInfo("Installation will continue after restart");
                } else {
                    application.exit(true, true);
                }
            }
        }, ModalityState.any());
    }

    private static boolean setupPatchDir(@NotNull File patchFile, @NotNull File patcherFile, @NotNull RepoPackage toInstallOrDelete, @NotNull RepoManager mgr, @NotNull FileOp fop, @NotNull ProgressIndicator progress) {
        File patchDir;
        File patchesDir = new File(mgr.getLocalPath(), PATCHES_DIR_NAME);
        int i = 1;
        while (true) {
            if (!fop.exists(patchDir = new File(patchesDir, PATCH_DIR_PREFIX + i))) break;
            ++i;
        }
        fop.mkdirs(patchDir);
        try {
            File completePatch = new File(patchDir, PATCH_JAR_FN);
            fop.copyFile(patcherFile, completePatch);
            try (FileSystem completeFs = FileSystems.newFileSystem(URI.create("jar:" + completePatch.toURI()), new HashMap());
                 FileSystem patchFs = FileSystems.newFileSystem(URI.create("jar:" + patchFile.toURI()), new HashMap());){
                Files.copy(patchFs.getPath(PATCH_ZIP_FN, new String[0]), completeFs.getPath(PATCH_ZIP_FN, new String[0]), new CopyOption[0]);
            }
            InstallerUtil.writePendingPackageXml((RepoPackage)toInstallOrDelete, (File)patchDir, (RepoManager)mgr, (FileOp)fop, (ProgressIndicator)progress);
        }
        catch (IOException e) {
            progress.logWarning("Error while setting up patch.", (Throwable)e);
            return false;
        }
        return true;
    }

    public static File generatePatch(PatchOperation patchOp, File destDir, FileOp fop, ProgressIndicator progress) {
        LocalPackage patcher = patchOp.getPatcher(progress.createSubProgress(0.1));
        progress.setFraction(0.1);
        if (patcher == null) {
            return null;
        }
        PatchRunner runner = new PatchRunner.DefaultFactory().getPatchRunner(patcher, progress, fop);
        if (runner == null) {
            return null;
        }
        LocalPackage existing = patchOp.getExisting();
        File existingRoot = existing == null ? null : existing.getLocation();
        String existingDescription = existing == null ? "None" : existing.getDisplayName() + " Version " + existing.getVersion();
        String description = patchOp.getNewVersionName();
        File destination = new File(destDir, PATCH_JAR_FN);
        File newFilesRoot = patchOp.getNewFilesRoot();
        if (runner.generatePatch(existingRoot, newFilesRoot, existingDescription, description, destination, progress.createSubProgress(1.0))) {
            progress.setFraction(1.0);
            return destination;
        }
        progress.setFraction(1.0);
        return null;
    }

    @Nullable
    public static PackageOperation getInProgressDependantPatcherInstall(@NotNull RemotePackage remote, @NotNull RepoManager mgr) {
        Map remotePackages = mgr.getPackages().getRemotePackages();
        for (Dependency dependency : remote.getAllDependencies()) {
            PackageOperation inProgress;
            RemotePackage remotePatcher;
            if (!dependency.getPath().startsWith("patcher;") || (remotePatcher = (RemotePackage)remotePackages.get(dependency.getPath())) == null || (inProgress = mgr.getInProgressInstallOperation((RepoPackage)remotePatcher)) == null || inProgress.getInstallStatus() == PackageOperation.InstallStatus.FAILED) continue;
            return inProgress;
        }
        return null;
    }
}

