/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.wizard;

import com.android.repository.api.InstallerFactory;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.adtui.validation.validators.FalseValidator;
import com.android.tools.adtui.validation.validators.TrueValidator;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolProperty;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.install.StudioSdkInstallerUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.ThrottledProgressWrapper;
import com.android.tools.idea.sdk.wizard.InstallTask;
import com.android.tools.idea.ui.wizard.deprecated.StudioWizardStepPanel;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstallSelectedPackagesStep
extends ModelWizardStep.WithoutModel {
    private final BoolProperty myInstallFailed;
    private final BoolProperty myInstallationFinished;
    private final ListenerManager myListeners;
    private final StudioWizardStepPanel myStudioPanel;
    private final ValidatorPanel myValidatorPanel;
    private final AndroidSdkHandler mySdkHandler;
    private JPanel myContentPanel;
    private JBLabel myLabelSdkPath;
    private JBLabel myProgressOverallLabel;
    private JTextArea mySdkManagerOutput;
    private JProgressBar myProgressBar;
    private JBLabel myProgressDetailLabel;
    private List<UpdatablePackage> myInstallRequests;
    private Collection<LocalPackage> myUninstallRequests;
    private final RepoManager myRepoManager;
    private com.android.repository.api.ProgressIndicator myLogger;
    private static final Object LOGGER_LOCK = new Object();
    private BackgroundAction myBackgroundAction;
    private final boolean myBackgroundable;
    private InstallerFactory myFactory;
    private boolean myThrottleProgress;

    public InstallSelectedPackagesStep(@NotNull List<UpdatablePackage> installRequests, @NotNull Collection<LocalPackage> uninstallRequests, @NotNull AndroidSdkHandler sdkHandler, boolean backgroundable) {
        this(installRequests, uninstallRequests, sdkHandler, backgroundable, StudioSdkInstallerUtil.createInstallerFactory(sdkHandler), false);
    }

    public InstallSelectedPackagesStep(@NotNull List<UpdatablePackage> installRequests, @NotNull Collection<LocalPackage> uninstallRequests, @NotNull AndroidSdkHandler sdkHandler, boolean backgroundable, @NotNull InstallerFactory factory, boolean throttleProgress) {
        super("Component Installer");
        this.$$$setupUI$$$();
        this.myInstallFailed = new BoolValueProperty();
        this.myInstallationFinished = new BoolValueProperty();
        this.myListeners = new ListenerManager();
        this.myBackgroundAction = new BackgroundAction();
        this.myInstallRequests = installRequests;
        this.myUninstallRequests = uninstallRequests;
        this.myRepoManager = sdkHandler.getSdkManager((com.android.repository.api.ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()));
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myContentPanel);
        this.myStudioPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel, "Installing Requested Components");
        this.myBackgroundable = backgroundable;
        this.mySdkHandler = sdkHandler;
        this.myFactory = factory;
        this.myThrottleProgress = throttleProgress;
    }

    @Override
    public Action getExtraAction() {
        return this.myBackgroundable ? this.myBackgroundAction : null;
    }

    @Override
    protected void onWizardStarting(@NotNull ModelWizard.Facade wizard) {
        String finishedText = "Please wait until the installation finishes";
        this.myValidatorPanel.registerValidator((ObservableValue)this.myInstallationFinished, (Validator)new TrueValidator(Validator.Severity.INFO, finishedText));
        String installError = "Installation did not complete successfully. See the IDE log for details";
        this.myValidatorPanel.registerValidator((ObservableValue)this.myInstallFailed, (Validator)new FalseValidator(installError));
        this.myBackgroundAction.setWizard(wizard);
        this.myListeners.listen(this.myInstallationFinished, v -> ApplicationManager.getApplication().invokeLater(wizard::updateNavigationProperties));
    }

    @Override
    protected void onEntering() {
        this.mySdkManagerOutput.setText("");
        this.myLabelSdkPath.setText(this.myRepoManager.getLocalPath().getPath());
        this.myInstallationFinished.set(false);
        this.startSdkInstall();
    }

    @Override
    protected boolean shouldShow() {
        return !this.myInstallRequests.isEmpty() || !this.myUninstallRequests.isEmpty();
    }

    @Override
    public boolean canGoBack() {
        return (Boolean)this.myInstallationFinished.get();
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        return this.myInstallationFinished;
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        return this.myStudioPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.myListeners.releaseAll();
        Object object = LOGGER_LOCK;
        synchronized (object) {
            if (this.myLogger != null && !this.myBackgroundAction.isBackgrounded()) {
                this.myLogger.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSdkInstall() {
        CustomLogger customLogger = new CustomLogger();
        Object object = LOGGER_LOCK;
        synchronized (object) {
            this.myLogger = this.myThrottleProgress ? new ThrottledProgressWrapper(customLogger) : customLogger;
        }
        Function<List<RepoPackage>, Void> completeCallback = failures -> {
            GuiUtils.invokeLaterIfNeeded(() -> {
                this.myProgressBar.setValue(100);
                this.myProgressOverallLabel.setText("");
                if (!failures.isEmpty()) {
                    this.myInstallFailed.set(true);
                    this.myProgressBar.setEnabled(false);
                } else {
                    this.myProgressDetailLabel.setText("Done");
                    InstallSelectedPackagesStep.checkForUpgrades(this.myInstallRequests);
                    this.myInstallRequests.clear();
                    this.myUninstallRequests.clear();
                }
                this.myInstallationFinished.set(true);
            }, (ModalityState)ModalityState.any());
            return null;
        };
        InstallTask task = new InstallTask(this.myFactory, this.mySdkHandler, StudioSettingsController.getInstance(), this.myLogger);
        task.setInstallRequests(this.myInstallRequests);
        task.setUninstallRequests(this.myUninstallRequests);
        task.setCompleteCallback(completeCallback);
        task.setPrepareCompleteCallback(() -> this.myBackgroundAction.setEnabled(false));
        this.myBackgroundAction.setTask(task);
        boolean hasOpenProjects = ProjectManager.getInstance().getOpenProjects().length > 0;
        Object indicator = hasOpenProjects ? new BackgroundableProcessIndicator((Task.Backgroundable)task) : new EmptyProgressIndicator();
        customLogger.setIndicator((ProgressIndicator)indicator);
        this.myLogger.logInfo("To install:");
        for (UpdatablePackage p : this.myInstallRequests) {
            this.myLogger.logInfo(String.format("- %1$s (%2$s)", p.getRemote().getDisplayName(), p.getRemote().getPath()));
        }
        this.myLogger.logInfo("");
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)indicator);
    }

    private static void checkForUpgrades(@Nullable List<UpdatablePackage> completedChanges) {
        if (completedChanges == null) {
            return;
        }
        int highestNewApiLevel = 0;
        for (UpdatablePackage updated : completedChanges) {
            int api;
            TypeDetails details = updated.getRepresentative().getTypeDetails();
            if (!(details instanceof DetailsTypes.PlatformDetailsType) || (api = ((DetailsTypes.PlatformDetailsType)details).getApiLevel()) <= highestNewApiLevel) continue;
            highestNewApiLevel = api;
        }
        if (highestNewApiLevel > 0) {
            PropertiesComponent.getInstance().setValue(WizardConstants.NEWLY_INSTALLED_API_KEY.name, highestNewApiLevel, -1);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JProgressBar jProgressBar;
        JBLabel jBLabel2;
        JTextArea jTextArea;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("SDK Path:");
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLabelSdkPath = jBLabel3 = new JBLabel();
        jBLabel3.setText("<placeholder path>");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setVerticalScrollBarPolicy(22);
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 7, null, null, null));
        this.mySdkManagerOutput = jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(true);
        jBScrollPane.setViewportView(jTextArea);
        this.myProgressOverallLabel = jBLabel2 = new JBLabel();
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel.add((Component)jProgressBar, new GridConstraints(3, 0, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myProgressDetailLabel = jBLabel = new JBLabel();
        jBLabel.setBackground(new Color(-3355444));
        jBLabel.setHorizontalTextPosition(10);
        jBLabel.setVerticalAlignment(1);
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 2, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class BackgroundAction
    extends AbstractAction {
        private boolean myIsBackgrounded = false;
        private ModelWizard.Facade myWizard;
        private InstallTask myTask;

        public BackgroundAction() {
            super("Background");
        }

        public void setTask(InstallTask task) {
            this.myTask = task;
        }

        public void setWizard(@NotNull ModelWizard.Facade wizard) {
            this.myWizard = wizard;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myIsBackgrounded = true;
            this.myTask.foregroundIndicatorClosed();
            this.myWizard.cancel();
        }

        public boolean isBackgrounded() {
            return this.myIsBackgrounded;
        }
    }

    private final class CustomLogger
    implements com.android.repository.api.ProgressIndicator {
        private ProgressIndicator myIndicator;
        private boolean myCancelled;
        private Logger myLogger = Logger.getInstance(this.getClass());
        private double myFraction = 0.0;

        private CustomLogger() {
        }

        public void setText(@Nullable String s) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressOverallLabel.setText(s));
            if (this.myIndicator != null) {
                this.myIndicator.setText(s);
            }
        }

        public boolean isCanceled() {
            return this.myCancelled;
        }

        public void cancel() {
            this.myCancelled = true;
            if (this.myIndicator != null) {
                this.myIndicator.cancel();
            }
        }

        public void setCancellable(boolean cancellable) {
        }

        public boolean isCancellable() {
            return true;
        }

        public void setIndeterminate(boolean indeterminate) {
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(indeterminate));
            if (this.myIndicator != null) {
                this.myIndicator.setIndeterminate(indeterminate);
            }
        }

        public boolean isIndeterminate() {
            return InstallSelectedPackagesStep.this.myProgressBar.isIndeterminate();
        }

        public void setFraction(double v) {
            this.myFraction = v;
            UIUtil.invokeLaterIfNeeded(() -> {
                InstallSelectedPackagesStep.this.myProgressBar.setIndeterminate(false);
                InstallSelectedPackagesStep.this.myProgressBar.setValue((int)(v * (double)(InstallSelectedPackagesStep.this.myProgressBar.getMaximum() - InstallSelectedPackagesStep.this.myProgressBar.getMinimum())));
            });
            if (this.myIndicator != null) {
                this.myIndicator.setFraction(v);
            }
        }

        public double getFraction() {
            return this.myFraction;
        }

        public void setSecondaryText(@Nullable String s) {
            if (s != null && s.length() > 80) {
                s = s.substring(s.length() - 80, s.length());
            }
            String label = s;
            UIUtil.invokeLaterIfNeeded(() -> InstallSelectedPackagesStep.this.myProgressDetailLabel.setText(label));
            if (this.myIndicator != null) {
                this.myIndicator.setText2(label);
            }
        }

        public void logWarning(@NotNull String s) {
            this.appendText(s);
            this.myLogger.warn(s);
        }

        public void logWarning(@NotNull String s, @Nullable Throwable e) {
            this.appendText(s);
            this.myLogger.warn(s, e);
        }

        public void logError(@NotNull String s) {
            this.appendText(s);
            this.myLogger.error(s);
        }

        public void logError(@NotNull String s, @Nullable Throwable e) {
            this.appendText(s);
            this.myLogger.error(s, e);
        }

        public void logInfo(@NotNull String s) {
            this.appendText(s);
            this.myLogger.info(s);
        }

        public void logVerbose(@NotNull String s) {
        }

        private void appendText(@NotNull String s) {
            UIUtil.invokeLaterIfNeeded(() -> {
                String current = InstallSelectedPackagesStep.this.mySdkManagerOutput.getText();
                String separator = "\n";
                if (current == null) {
                    current = "";
                } else if (current.endsWith("\n")) {
                    separator = "";
                }
                InstallSelectedPackagesStep.this.mySdkManagerOutput.setText(current + separator + s);
            });
        }

        public void setIndicator(ProgressIndicator indicator) {
            this.myIndicator = indicator;
        }
    }
}

