/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.actions.CreateClassAction;
import com.android.tools.idea.actions.MakeIdeaModuleAction;
import com.android.tools.idea.gradle.util.AndroidStudioPreferences;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.startup.Actions;
import com.android.tools.idea.stats.AndroidStudioUsageTracker;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationProducer;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationInjector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.GradleOrderEnumeratorHandler;

public class AndroidStudioInitializer
implements Runnable {
    private static final Logger LOG = Logger.getInstance(AndroidStudioInitializer.class);
    private static final List<String> IDE_SETTINGS_TO_REMOVE = Lists.newArrayList((Object[])new String[]{"org.jetbrains.plugins.javaFX.JavaFxSettingsConfigurable", "org.intellij.plugins.xpathView.XPathConfigurable", "org.intellij.lang.xpath.xslt.impl.XsltConfigImpl$UIImpl"});

    @Override
    public void run() {
        AndroidStudioInitializer.checkInstallation();
        AndroidStudioInitializer.removeIdeSettings();
        AndroidStudioInitializer.setUpNewFilePopupActions();
        AndroidStudioInitializer.setUpMakeActions();
        AndroidStudioInitializer.disableGroovyLanguageInjection();
        AndroidStudioInitializer.setUpNewProjectActions();
        AndroidStudioInitializer.setupAnalytics();
        AndroidStudioInitializer.disableGradleOrderEnumeratorHandler();
        AndroidStudioInitializer.disableIdeaJUnitConfigurations();
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getScheme("Default");
        TextAttributes textAttributes = colorsScheme.getAttributes(HighlighterColors.TEXT);
        TextAttributes xmlTagAttributes = colorsScheme.getAttributes(XmlHighlighterColors.XML_TAG);
        xmlTagAttributes.setBackgroundColor(textAttributes.getBackgroundColor());
    }

    private static void setupAnalytics() {
        AndroidStudioUsageTracker.setup(JobScheduler.getScheduler());
        ApplicationInfo application = ApplicationInfo.getInstance();
        UsageTracker.getInstance().setVersion(application.getStrictVersion());
    }

    private static void checkInstallation() {
        String studioHome = PathManager.getHomePath();
        if (StringUtil.isEmpty((String)studioHome)) {
            LOG.info("Unable to find Studio home directory");
            return;
        }
        File studioHomePath = FilePaths.toSystemDependentPath(studioHome);
        if (!studioHomePath.isDirectory()) {
            LOG.info(String.format("The path '%1$s' does not belong to an existing directory", studioHomePath.getPath()));
            return;
        }
        File androidPluginLibFolderPath = new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android", "lib"}));
        if (!androidPluginLibFolderPath.isDirectory()) {
            LOG.info(String.format("The path '%1$s' does not belong to an existing directory", androidPluginLibFolderPath.getPath()));
            return;
        }
        String cause = null;
        File[] children = FileUtil.notNullize((File[])androidPluginLibFolderPath.listFiles());
        if (AndroidStudioInitializer.hasMoreThanOneBuilderModelFile(children)) {
            cause = "(Found multiple versions of builder-model-*.jar in plugins/android/lib.)";
        } else if (new File(studioHomePath, FileUtil.join((String[])new String[]{"plugins", "android-designer"})).exists()) {
            cause = "(Found plugins/android-designer which should not be present.)";
        }
        if (cause != null) {
            String msg = "Your Android Studio installation is corrupt and will not work properly.\n" + cause + "\nThis usually happens if Android Studio is extracted into an existing older version.\n\nPlease reinstall (and make sure the new installation directory is empty first.)";
            String title = "Corrupt Installation";
            int option = Messages.showDialog((String)msg, (String)title, (String[])new String[]{"Quit", "Proceed Anyway"}, (int)0, (Icon)Messages.getErrorIcon());
            if (option == 0) {
                ApplicationManagerEx.getApplicationEx().exit();
            }
        }
    }

    @VisibleForTesting
    static boolean hasMoreThanOneBuilderModelFile(@NotNull File[] libraryFiles) {
        int builderModelFileCount = 0;
        for (File file : libraryFiles) {
            String fileName = file.getName();
            if (!fileName.startsWith("builder-model-") || !"jar".equals(FileUtilRt.getExtension((String)fileName)) || ++builderModelFileCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static void removeIdeSettings() {
        try {
            ExtensionPoint ideConfigurable = Extensions.getRootArea().getExtensionPoint(Configurable.APPLICATION_CONFIGURABLE);
            AndroidStudioPreferences.cleanUpPreferences((ExtensionPoint<ConfigurableEP<Configurable>>)ideConfigurable, IDE_SETTINGS_TO_REMOVE);
        }
        catch (Throwable e) {
            LOG.info("Failed to clean up IDE preferences", e);
        }
    }

    private static void setUpNewFilePopupActions() {
        Actions.hideAction("NewHtmlFile");
        Actions.hideAction("NewPackageInfo");
        Actions.hideAction("NewForm");
        Actions.hideAction("NewDialog");
        Actions.hideAction("NewFormSnapshot");
        Actions.hideAction("Groovy.NewClass");
        Actions.hideAction("Groovy.NewScript");
    }

    private static void setUpMakeActions() {
        Actions.hideAction("CompileDirty");
        Actions.replaceAction("MakeModule", new MakeIdeaModuleAction());
        Actions.hideAction("CompileProject");
        Actions.hideAction("Compile");
    }

    private static void disableGroovyLanguageInjection() {
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectManagerAdapter(){

            public void projectOpened(@NotNull Project project) {
                ExtensionPoint extensionPoint = Extensions.getArea((AreaInstance)project).getExtensionPoint(MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME);
                for (MultiHostInjector injector : (MultiHostInjector[])extensionPoint.getExtensions()) {
                    if (!(injector instanceof GrConcatenationInjector)) continue;
                    extensionPoint.unregisterExtension((Object)injector);
                    return;
                }
                LOG.info("Failed to disable 'org.intellij.plugins.intelliLang.inject.groovy.GrConcatenationInjector'");
            }
        });
    }

    private static void setUpNewProjectActions() {
        Actions.replaceAction("NewClass", new CreateClassAction());
        FileTemplateManager fileTemplateManager = FileTemplateManager.getDefaultInstance();
        fileTemplateManager.getTemplate("Singleton").setText(fileTemplateManager.getJ2eeTemplate("Singleton").getText());
        for (String templateName : new String[]{"Class", "Interface", "Enum", "AnnotationType"}) {
            FileTemplate template = fileTemplateManager.getInternalTemplate(templateName);
            template.setText(fileTemplateManager.getJ2eeTemplate(templateName).getText());
        }
    }

    private static void disableGradleOrderEnumeratorHandler() {
        ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(OrderEnumerationHandler.EP_NAME);
        for (OrderEnumerationHandler.Factory factory : (OrderEnumerationHandler.Factory[])extensionPoint.getExtensions()) {
            if (!(factory instanceof GradleOrderEnumeratorHandler.FactoryImpl)) continue;
            extensionPoint.unregisterExtension((Object)factory);
            return;
        }
    }

    private static void disableIdeaJUnitConfigurations() {
        ExtensionPoint configurationProducerExtensionPoint = Extensions.getRootArea().getExtensionPoint(RunConfigurationProducer.EP_NAME);
        for (RunConfigurationProducer runConfigurationProducer : (RunConfigurationProducer[])configurationProducerExtensionPoint.getExtensions()) {
            if (!(runConfigurationProducer instanceof JUnitConfigurationProducer) || runConfigurationProducer instanceof AndroidJUnitConfigurationProducer) continue;
            configurationProducerExtensionPoint.unregisterExtension((Object)runConfigurationProducer);
        }
        ExtensionPoint configurationTypeExtensionPoint = Extensions.getRootArea().getExtensionPoint(ConfigurationType.CONFIGURATION_TYPE_EP);
        for (ConfigurationType configurationType : (ConfigurationType[])configurationTypeExtensionPoint.getExtensions()) {
            if (!(configurationType instanceof JUnitConfigurationType) || configurationType instanceof AndroidJUnitConfigurationType) continue;
            configurationTypeExtensionPoint.unregisterExtension((Object)configurationType);
        }
        Actions.hideAction("excludeFromSuite");
        Actions.hideAction("AddToISuite");
    }
}

