/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.startup;

import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.ResourceClassRegistry;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedInitialization {
    private final Project myProject;
    private final GradleSyncState mySyncState;
    private final GradleSyncInvoker mySyncInvoker;
    private final GradleBuildState myBuildState;
    private final List<RunnablePair> myRunnables;
    private final Object myLock = new Object();

    @NotNull
    public static DelayedInitialization getInstance(@NotNull Project project) {
        return (DelayedInitialization)ServiceManager.getService((Project)project, DelayedInitialization.class);
    }

    public DelayedInitialization(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleBuildState buildState) {
        this.myProject = project;
        this.mySyncState = syncState;
        this.mySyncInvoker = syncInvoker;
        this.myBuildState = buildState;
        this.myRunnables = new ArrayList<RunnablePair>();
        GradleBuildState.subscribe(project, new BuildListener());
        GradleSyncState.subscribe(project, new SyncListener());
        this.runAfterBuild(this::clearResourceCache, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAfterBuild(@NotNull Runnable success, @Nullable Runnable buildFailure) {
        GradleBuildStatus status;
        Object object = this.myLock;
        synchronized (object) {
            status = this.getBuildStatus();
            if (status != GradleBuildStatus.BUILD_SUCCESS) {
                this.myRunnables.add(new RunnablePair(success, buildFailure));
            }
        }
        switch (status) {
            case BUILDING: {
                break;
            }
            case BUILD_NEEDED: {
                this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED, null);
                break;
            }
            case BUILD_ERROR: {
                if (buildFailure == null) break;
                buildFailure.run();
                break;
            }
            case BUILD_SUCCESS: {
                success.run();
                break;
            }
            default: {
                assert (false) : "Not Implemented";
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterBuild() {
        boolean buildError = this.getBuildStatus() != GradleBuildStatus.BUILD_SUCCESS;
        ArrayList<RunnablePair> runnables = new ArrayList<RunnablePair>();
        Object object = this.myLock;
        synchronized (object) {
            runnables.addAll(this.myRunnables);
            if (!buildError) {
                this.myRunnables.clear();
            }
        }
        runnables.stream().map(pair -> buildError ? pair.failure : pair.success).filter(Objects::nonNull).forEach(Runnable::run);
    }

    private void clearResourceCache() {
        if (AppResourceRepository.testAndClearTempResourceCached(this.myProject)) {
            ResourceClassRegistry.get(this.myProject).clearCache();
            for (AndroidFacet facet : AndroidUtils.getApplicationFacets(this.myProject)) {
                facet.refreshResources();
                ModuleResourceManagers.getInstance(facet).getLocalResourceManager().invalidateAttributeDefinitions();
            }
        }
    }

    private GradleBuildStatus getBuildStatus() {
        if (this.mySyncState.isSyncInProgress()) {
            return GradleBuildStatus.BUILDING;
        }
        if (this.mySyncState.getSummary().getSyncTimestamp() > 0L && this.mySyncState.lastSyncFailedOrHasIssues()) {
            return GradleBuildStatus.BUILD_ERROR;
        }
        BuildSummary buildSummary = this.myBuildState.getSummary();
        if (buildSummary == null || this.myBuildState.isBuildInProgress()) {
            return GradleBuildStatus.BUILDING;
        }
        if (buildSummary.getTimestamp() < 0L || buildSummary.getStatus() == BuildStatus.CANCELED || this.mySyncState.isSyncNeeded() != ThreeState.NO) {
            return GradleBuildStatus.BUILD_NEEDED;
        }
        if (buildSummary.getStatus() == BuildStatus.FAILED) {
            return GradleBuildStatus.BUILD_ERROR;
        }
        return GradleBuildStatus.BUILD_SUCCESS;
    }

    private static class RunnablePair {
        public final Runnable success;
        public final Runnable failure;

        private RunnablePair(@NotNull Runnable success, @Nullable Runnable failure) {
            this.success = success;
            this.failure = failure;
        }
    }

    private class BuildListener
    extends GradleBuildListener.Adapter {
        private BuildListener() {
        }

        @Override
        public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
            DelayedInitialization.this.afterBuild();
        }
    }

    private class SyncListener
    extends GradleSyncListener.Adapter {
        private SyncListener() {
        }

        @Override
        public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
            DelayedInitialization.this.afterBuild();
        }

        @Override
        public void syncSkipped(@NotNull Project project) {
            DelayedInitialization.this.afterBuild();
        }
    }

    private static enum GradleBuildStatus {
        BUILDING,
        BUILD_NEEDED,
        BUILD_ERROR,
        BUILD_SUCCESS;

    }
}

