/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.ddmlib.IDevice;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.base.Strings;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.google.wireless.android.sdk.stats.ProductDetails;
import com.google.wireless.android.sdk.stats.StudioProjectChange;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class AndroidStudioUsageTracker {
    public static void setup(ScheduledExecutorService scheduler) {
        scheduler.scheduleWithFixedDelay(AndroidStudioUsageTracker::runDailyReports, 0L, 1L, TimeUnit.DAYS);
        scheduler.scheduleWithFixedDelay(AndroidStudioUsageTracker::runHourlyReports, 0L, 1L, TimeUnit.HOURS);
        AndroidStudioUsageTracker.subscribeToEvents();
    }

    private static void subscribeToEvents() {
        Application app = ApplicationManager.getApplication();
        MessageBusConnection connection = app.getMessageBus().connect();
        connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleTracker());
    }

    private static void runDailyReports() {
        ApplicationInfo application = ApplicationInfo.getInstance();
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.PING).setKind(AndroidStudioEvent.EventKind.STUDIO_PING).setProductDetails(ProductDetails.newBuilder().setProduct(ProductDetails.ProductKind.STUDIO).setBuild(application.getBuild().asString()).setVersion(application.getStrictVersion()).setOsArchitecture(CommonMetricsData.getOsArchitecture()).setChannel(AndroidStudioUsageTracker.lifecycleChannelFromUpdateSettings())).setMachineDetails(CommonMetricsData.getMachineDetails((File)new File(PathManager.getHomePath()))).setJvmDetails(CommonMetricsData.getJvmDetails()));
    }

    private static void runHourlyReports() {
        UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.STUDIO_PROCESS_STATS).setJavaProcessStats(CommonMetricsData.getJavaProcessStats()));
    }

    @Deprecated
    @NotNull
    public static String anonymizeUtf8(@NotNull String value) {
        return AnonymizerUtil.anonymizeUtf8((String)value);
    }

    @NotNull
    public static DeviceInfo deviceToDeviceInfo(@NotNull IDevice device) {
        return DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)device.getSerialNumber())).setBuildTags(Strings.nullToEmpty((String)device.getProperty("ro.build.tags"))).setBuildType(Strings.nullToEmpty((String)device.getProperty("ro.build.type"))).setBuildVersionRelease(Strings.nullToEmpty((String)device.getProperty("ro.build.version.release"))).setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)device.getProperty("ro.product.cpu.abi"))).setManufacturer(Strings.nullToEmpty((String)device.getProperty("ro.product.manufacturer"))).setDeviceType(device.isEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).setModel(Strings.nullToEmpty((String)device.getProperty("ro.product.model"))).build();
    }

    @NotNull
    public static DeviceInfo deviceToDeviceInfoApilLevelOnly(@NotNull IDevice device) {
        return DeviceInfo.newBuilder().setBuildApiLevelFull(Strings.nullToEmpty((String)device.getProperty("ro.build.version.sdk"))).build();
    }

    private static ProductDetails.SoftwareLifeCycleChannel lifecycleChannelFromUpdateSettings() {
        switch (UpdateSettings.getInstance().getSelectedChannelStatus()) {
            case EAP: {
                return ProductDetails.SoftwareLifeCycleChannel.CANARY;
            }
            case MILESTONE: {
                return ProductDetails.SoftwareLifeCycleChannel.DEV;
            }
            case BETA: {
                return ProductDetails.SoftwareLifeCycleChannel.BETA;
            }
            case RELEASE: {
                return ProductDetails.SoftwareLifeCycleChannel.STABLE;
            }
        }
        return ProductDetails.SoftwareLifeCycleChannel.UNKNOWN_LIFE_CYCLE_CHANNEL;
    }

    private static class ProjectLifecycleTracker
    extends ProjectLifecycleListener.Adapter {
        private ProjectLifecycleTracker() {
        }

        public void beforeProjectLoaded(@NotNull Project project) {
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_OPENED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen)));
        }

        public void afterProjectClosed(@NotNull Project project) {
            int projectsOpen = ProjectManager.getInstance().getOpenProjects().length;
            UsageTracker.getInstance().log(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.STUDIO_PROJECT_CLOSED).setStudioProjectChange(StudioProjectChange.newBuilder().setProjectsOpen(projectsOpen)));
        }
    }
}

