/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.stats;

import com.android.tools.analytics.UsageTracker;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.wireless.android.play.playlog.proto.ClientAnalytics;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class StatisticsViewer
extends JPanel
implements Disposable {
    public static final String ID = "StatisticsViewer";
    public static final String TITLE = "Android Studio Usage Statistics";
    private final ConsoleViewImpl myConsoleView;
    private DialogWrapper myDialog;
    private UsageTracker myOriginalUsageTracker;

    StatisticsViewer() {
        super(new BorderLayout(0, 0));
        Disposer.register((Disposable)Disposer.get((String)"ui"), (Disposable)this);
        Project project = ProjectManager.getInstance().getDefaultProject();
        this.myConsoleView = new ConsoleViewImpl(project, true);
        this.hookUsageTracker();
        this.layoutConsoleView();
        this.createDialog(project);
    }

    private void hookUsageTracker() {
        this.myOriginalUsageTracker = UsageTracker.getInstance();
        UsageTracker.setInstanceForTest((UsageTracker)new UsageTracker(this.myOriginalUsageTracker.getAnalyticsSettings(), this.myOriginalUsageTracker.getScheduler()){

            public void logDetails(ClientAnalytics.LogEvent.Builder logEvent) {
                StatisticsViewer.this.myOriginalUsageTracker.logDetails(logEvent);
                try {
                    AndroidStudioEvent androidStudioEvent = AndroidStudioEvent.parseFrom((ByteString)logEvent.getSourceExtension());
                    logEvent.clearSourceExtension();
                    StatisticsViewer.this.myConsoleView.print("===\n", ConsoleViewContentType.NORMAL_OUTPUT);
                    StatisticsViewer.this.myConsoleView.print(logEvent.build().toString(), ConsoleViewContentType.NORMAL_OUTPUT);
                    StatisticsViewer.this.myConsoleView.print(androidStudioEvent.toString(), ConsoleViewContentType.NORMAL_OUTPUT);
                }
                catch (InvalidProtocolBufferException e) {
                    StatisticsViewer.this.myConsoleView.print("Unable to parse AndroidStudioEvent from LogEvent: " + logEvent.build().toString(), ConsoleViewContentType.ERROR_OUTPUT);
                }
            }

            public void close() throws Exception {
                StatisticsViewer.this.myOriginalUsageTracker.close();
            }
        });
        UsageTracker.getInstance().setVersion(this.myOriginalUsageTracker.getVersion());
    }

    private void createDialog(Project project) {
        this.myDialog = new DialogWrapper(project, true){
            {
                this.init();
            }

            protected JComponent createCenterPanel() {
                Disposer.register((Disposable)this.getDisposable(), (Disposable)StatisticsViewer.this);
                return StatisticsViewer.this;
            }

            protected String getDimensionServiceKey() {
                return StatisticsViewer.ID;
            }

            @NotNull
            protected Action[] createActions() {
                return new Action[]{new AbstractAction("Close"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.doOKAction();
                    }
                }};
            }
        };
        this.myDialog.setModal(false);
        this.myDialog.setTitle(TITLE);
        this.myDialog.setResizable(true);
        this.myDialog.show();
    }

    private void layoutConsoleView() {
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)this.myConsoleView, null, (JComponent)this, TITLE);
        Disposer.register((Disposable)this, (Disposable)descriptor);
        JComponent consoleViewComponent = this.myConsoleView.getComponent();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAll(this.myConsoleView.createConsoleActions());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, false);
        toolbar.setTargetComponent(consoleViewComponent);
        JComponent ui = descriptor.getComponent();
        ui.add((Component)consoleViewComponent, "Center");
        ui.add((Component)toolbar.getComponent(), "West");
        consoleViewComponent.setBorder(BorderFactory.createLineBorder((Color)JBColor.GRAY));
    }

    @Override
    public void show() {
        this.myDialog.getPeer().getWindow().toFront();
    }

    public void dispose() {
        UsageTracker.setInstanceForTest((UsageTracker)this.myOriginalUsageTracker);
    }
}

