/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.structure.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Reader;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;

@XmlRootElement(name="servicebundle")
public class ServiceBundle {
    @XmlAttribute(name="name")
    private String myName;
    @XmlElements(value={@XmlElement(name="service", type=Service.class)})
    private List<Service> myServices = Lists.newArrayList();

    public static ServiceBundle parse(@NotNull Reader xmlReader) throws JAXBException {
        return ServiceBundle.unmarshal(xmlReader);
    }

    private static ServiceBundle unmarshal(@NotNull Reader xmlReader) throws JAXBException {
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{ServiceBundle.class}).createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                throw new RuntimeException(event.getLinkedException());
            }
        });
        return (ServiceBundle)unmarshaller.unmarshal(xmlReader);
    }

    public List<Service> getServices() {
        return ImmutableList.copyOf(this.myServices);
    }

    public String toString() {
        return "ServiceBundle{myName='" + this.myName + '\'' + ", myServices=" + this.myServices + '}';
    }

    public static final class Service {
        @XmlAttribute(name="name")
        @NotNull
        private String myName;
        @XmlAttribute(name="resourceRoot")
        @NotNull
        private String myResourceRoot;
        @XmlElements(value={@XmlElement(name="resource", type=String.class)})
        private List<String> myResources = Lists.newArrayList();

        public List<String> getResources() {
            return ImmutableList.copyOf(this.myResources);
        }

        public String getResourceRoot() {
            return this.myResourceRoot;
        }

        public String toString() {
            return "Service{myName='" + this.myName + '\'' + ", myResourceRoot='" + this.myResourceRoot + '\'' + ", myResources=" + this.myResources + '}';
        }
    }
}

