/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.repository.GradleCoordinate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GradleFileMergers {
    static final String DEPENDENCIES = "dependencies";
    private static final ImmutableList<String> KNOWN_CONFIGURATIONS_IN_ORDER = ImmutableList.of((Object)"feature", (Object)"api", (Object)"implementation", (Object)"compile", (Object)"testApi", (Object)"testImplementation", (Object)"testCompile", (Object)"androidTestApi", (Object)"androidTestImplementation", (Object)"androidTestCompile", (Object)"androidTestUtil");
    private static final ImmutableSet<ImmutableSet<String>> CONFIGURATION_GROUPS = ImmutableSet.of((Object)ImmutableSet.of((Object)"feature", (Object)"api", (Object)"implementation", (Object)"compile"), (Object)ImmutableSet.of((Object)"testApi", (Object)"testImplementation", (Object)"testCompile"), (Object)ImmutableSet.of((Object)"androidTestApi", (Object)"androidTestImplementation", (Object)"androidTestCompile"));
    static final Ordering<String> CONFIGURATION_ORDERING = Ordering.natural().onResultOf(input -> {
        int result = KNOWN_CONFIGURATIONS_IN_ORDER.indexOf(input);
        return Integer.valueOf(result != -1 ? result : KNOWN_CONFIGURATIONS_IN_ORDER.size());
    }).compound((Comparator)Ordering.natural());

    public static void removeExistingDependencies(@NotNull Map<String, Multimap<String, GradleCoordinate>> newDependencies, @NotNull Map<String, Multimap<String, GradleCoordinate>> existingDependencies) {
        for (String configuration : newDependencies.keySet()) {
            for (String possibleConfiguration : GradleFileMergers.getConfigurationGroup(configuration)) {
                if (!existingDependencies.containsKey(possibleConfiguration)) continue;
                for (String coordinateId : existingDependencies.get(possibleConfiguration).keySet()) {
                    newDependencies.get(configuration).removeAll((Object)coordinateId);
                }
            }
        }
    }

    private GradleFileMergers() {
    }

    private static ImmutableSet<String> getConfigurationGroup(String configuration) {
        for (ImmutableSet group : CONFIGURATION_GROUPS) {
            if (!group.contains((Object)configuration)) continue;
            return group;
        }
        return ImmutableSet.of((Object)configuration);
    }
}

