/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.ide.common.signing.KeystoreHelper;
import com.android.prefs.AndroidLocation;
import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.GradleBuildFile;
import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.parser.NamedObject;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class KeystoreUtils {
    @NotNull
    public static File getDebugKeystore(@NotNull AndroidFacet facet) throws Exception {
        File gradleDebugKeystore = KeystoreUtils.getGradleDebugKeystore(facet);
        if (gradleDebugKeystore != null) {
            return gradleDebugKeystore;
        }
        JpsAndroidModuleProperties state = ((AndroidFacetConfiguration)facet.getConfiguration()).getState();
        if (state != null && !Strings.isNullOrEmpty((String)state.CUSTOM_DEBUG_KEYSTORE_PATH)) {
            return new File(state.CUSTOM_DEBUG_KEYSTORE_PATH);
        }
        return KeystoreUtils.getOrCreateDefaultDebugKeystore();
    }

    public static File getOrCreateDefaultDebugKeystore() throws Exception {
        try {
            File debugLocation = new File(KeystoreHelper.defaultDebugKeystoreLocation());
            if (!debugLocation.exists()) {
                File keystoreDirectory = new File(AndroidLocation.getFolder());
                if (!keystoreDirectory.canWrite()) {
                    throw new AndroidLocation.AndroidLocationException("Could not create debug keystore because \"" + keystoreDirectory + "\" is not writable");
                }
                StdLogger logger = new StdLogger(StdLogger.Level.ERROR);
                KeystoreHelper.createDebugStore(null, (File)debugLocation, (String)"android", (String)"android", (String)"AndroidDebugKey", (ILogger)logger);
            }
            if (!debugLocation.exists()) {
                throw new AndroidLocation.AndroidLocationException("Could not create debug keystore");
            }
            return debugLocation;
        }
        catch (AndroidLocation.AndroidLocationException exception) {
            throw new Exception("Failed to get debug keystore path", exception);
        }
    }

    @Nullable
    private static File getGradleDebugKeystore(@NotNull AndroidFacet facet) {
        GradleSettingsFile gradleSettingsFile = GradleSettingsFile.get(facet.getModule().getProject());
        if (gradleSettingsFile == null) {
            return null;
        }
        String modulePath = GradleSettingsFile.getModuleGradlePath(facet.getModule());
        if (modulePath == null) {
            return null;
        }
        final GradleBuildFile moduleBuildFile = gradleSettingsFile.getModuleBuildFile(modulePath);
        if (moduleBuildFile == null) {
            return null;
        }
        Iterable signingConfigs = (Iterable)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Iterable<NamedObject>>(){

            public Iterable<NamedObject> compute() {
                return (Iterable)moduleBuildFile.getValue(BuildFileKey.SIGNING_CONFIGS);
            }
        });
        if (signingConfigs == null) {
            return null;
        }
        for (NamedObject namedObject : signingConfigs) {
            File debugKey;
            if (!"debug".equals(namedObject.getName()) || (debugKey = (File)namedObject.getValue(BuildFileKey.STORE_FILE)) == null) continue;
            return new File(ModuleUtilCore.getModuleDirPath((Module)facet.getModule()), debugKey.getPath());
        }
        return null;
    }

    @NotNull
    public static String sha1(@NotNull File keyStoreFile) throws Exception {
        return KeystoreUtils.sha1(keyStoreFile, null, null);
    }

    @NotNull
    public static String sha1(@NotNull File keyStoreFile, @Nullable String keyAlias, @Nullable String keyStorePassword) throws Exception {
        Certificate signingCert = KeystoreUtils.getCertificate(keyStoreFile, keyAlias, keyStorePassword);
        try {
            byte[] certBytes = MessageDigest.getInstance("SHA1").digest(signingCert.getEncoded());
            return BaseEncoding.base16().withSeparator(":", 2).encode(certBytes);
        }
        catch (Exception e) {
            throw new Exception("Could not compute SHA1 hash from certificate", e);
        }
    }

    @NotNull
    private static Certificate getCertificate(@NotNull File keyStoreFile, @Nullable String certificateAlias, @Nullable String keyStorePassword) throws Exception {
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            if (keyStorePassword == null) {
                keyStorePassword = "android";
            }
            keyStore.load(new FileInputStream(keyStoreFile), keyStorePassword.toCharArray());
            if (certificateAlias == null) {
                certificateAlias = keyStore.aliases().nextElement();
            }
            return keyStore.getCertificate(certificateAlias);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            throw new Exception("Could not extract certificate from file.", exception);
        }
    }
}

