/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates;

import com.android.tools.idea.templates.CircularParameterDependencyException;
import com.android.tools.idea.templates.Parameter;
import com.android.tools.idea.templates.StringEvaluator;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.text.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ParameterValueResolver {
    @NotNull
    private static final Deduplicator DO_NOTHING_DEDUPLICATOR = (parameter, value) -> value;
    @NotNull
    private final Set<Parameter> myComputedParameters = Sets.newHashSet();
    @NotNull
    private final Set<Parameter> myStaticParameters = Sets.newHashSet();
    @NotNull
    private final Deduplicator myDeduplicator;
    @NotNull
    private final StringEvaluator myStringEvaluator = new StringEvaluator();
    @NotNull
    private final Map<Parameter, Object> myUserValues;
    @NotNull
    private final Map<String, Object> myAdditionalValues;

    @NotNull
    public static Map<Parameter, Object> resolve(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues) throws CircularParameterDependencyException {
        return ParameterValueResolver.resolve(parameters, userValues, additionalValues, DO_NOTHING_DEDUPLICATOR);
    }

    @NotNull
    public static Map<Parameter, Object> resolve(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues, @NotNull Deduplicator deduplicator) throws CircularParameterDependencyException {
        ParameterValueResolver resolver = new ParameterValueResolver(parameters, userValues, additionalValues, deduplicator);
        return resolver.resolve();
    }

    private ParameterValueResolver(@NotNull Iterable<Parameter> parameters, @NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues, @NotNull Deduplicator deduplicator) {
        this.myUserValues = userValues;
        this.myAdditionalValues = additionalValues;
        for (Parameter parameter : parameters) {
            if (parameter == null || StringUtil.isEmptyOrSpaces((String)parameter.id)) continue;
            if (!StringUtil.isEmptyOrSpaces((String)ParameterValueResolver.getSuggestOrInitial(parameter)) && !userValues.containsKey(parameter)) {
                this.myComputedParameters.add(parameter);
                continue;
            }
            this.myStaticParameters.add(parameter);
        }
        this.myDeduplicator = deduplicator;
    }

    @NotNull
    private static String getSuggestOrInitial(Parameter parameter) {
        return StringUtil.isEmptyOrSpaces((String)parameter.suggest) && parameter.constraints.contains((Object)Parameter.Constraint.UNIQUE) ? parameter.initial : parameter.suggest;
    }

    @Nullable
    private static Object decodeInitialValue(@NotNull Parameter input, @Nullable String initial) {
        if (initial != null && input.type == Parameter.Type.BOOLEAN) {
            return Boolean.valueOf(initial);
        }
        return initial;
    }

    @NotNull
    public Map<Parameter, Object> resolve() throws CircularParameterDependencyException {
        Map<String, Object> staticValues = this.getStaticParameterValues(this.myUserValues, this.myAdditionalValues);
        Map<String, Object> computedValues = this.computeParameterValues(staticValues);
        HashMap allValues = Maps.newHashMapWithExpectedSize((int)(computedValues.size() + staticValues.size()));
        for (Parameter parameter : Iterables.concat(this.myStaticParameters, this.myComputedParameters)) {
            allValues.put(parameter, computedValues.get(parameter.id));
        }
        return allValues;
    }

    @Nullable
    private Object computeParameterValue(@NotNull Parameter computedParameter, @NotNull Map<String, Object> currentValues) {
        String suggest = ParameterValueResolver.getSuggestOrInitial(computedParameter);
        assert (!StringUtil.isEmptyOrSpaces((String)suggest));
        String value = this.myStringEvaluator.evaluate(suggest, currentValues);
        value = this.myDeduplicator.deduplicate(computedParameter, value);
        return ParameterValueResolver.decodeInitialValue(computedParameter, value);
    }

    @NotNull
    private Map<String, Object> getStaticParameterValues(@NotNull Map<Parameter, Object> userValues, @NotNull Map<String, Object> additionalValues) {
        HashMap knownValues = Maps.newHashMapWithExpectedSize((int)(this.myStaticParameters.size() + additionalValues.size()));
        knownValues.putAll(additionalValues);
        for (Parameter parameter : this.myStaticParameters) {
            Object value;
            if (userValues.containsKey(parameter)) {
                value = userValues.get(parameter);
            } else if (additionalValues.containsKey(parameter.id)) {
                value = additionalValues.get(parameter.id);
            } else {
                String initial = parameter.initial;
                value = ParameterValueResolver.decodeInitialValue(parameter, initial);
            }
            knownValues.put(parameter.id, value);
        }
        return knownValues;
    }

    @NotNull
    private Map<String, Object> computeParameterValues(@NotNull Map<String, Object> staticValues) throws CircularParameterDependencyException {
        HashMap computedValues = Maps.newHashMapWithExpectedSize((int)(this.myComputedParameters.size() + staticValues.size()));
        computedValues.putAll(staticValues);
        for (Parameter parameter : this.myComputedParameters) {
            computedValues.put(parameter.id, "");
        }
        int maxIterations = 2 * this.myComputedParameters.size();
        Object updatedValues = ImmutableMap.of();
        for (int i = 0; i <= maxIterations; ++i) {
            updatedValues = this.computeUpdatedValues(computedValues);
            if (updatedValues.isEmpty()) {
                return computedValues;
            }
            computedValues.putAll(updatedValues);
        }
        throw new CircularParameterDependencyException(updatedValues.keySet());
    }

    @NotNull
    private Map<String, Object> computeUpdatedValues(@NotNull Map<String, Object> values) {
        HashMap updatedValues = Maps.newHashMapWithExpectedSize((int)this.myComputedParameters.size());
        for (Parameter computedParameter : this.myComputedParameters) {
            Object value = this.computeParameterValue(computedParameter, values);
            String id = computedParameter.id;
            if (Objects.equal((Object)values.get(id), (Object)value)) continue;
            updatedValues.put(id, value);
        }
        return updatedValues;
    }

    public static interface Deduplicator {
        @Nullable
        public String deduplicate(@NotNull Parameter var1, @Nullable String var2);
    }
}

