/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.templates.recipe;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.BuildSystemService;
import com.android.tools.idea.templates.FmGetConfigurationNameMethod;
import com.android.tools.idea.templates.FreemarkerUtils;
import com.android.tools.idea.templates.RecipeMergeUtils;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.templates.recipe.FindReferencesRecipeExecutor;
import com.android.tools.idea.templates.recipe.RecipeExecutor;
import com.android.tools.idea.templates.recipe.RenderingContext;
import com.google.common.base.Strings;
import com.google.common.collect.SetMultimap;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.LineSeparator;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultRecipeExecutor
implements RecipeExecutor {
    private static final String GRADLE_PROJECT_SETTINGS_FILE = "settings.gradle";
    private static final String CLASSPATH_CONFIGURATION_NAME = "classpath";
    private static final String LINE_SEPARATOR = LineSeparator.getSystemLineSeparator().getSeparatorString();
    private final FindReferencesRecipeExecutor myReferences;
    private final RenderingContext myContext;
    private final RecipeIO myIO;
    private final ReadonlyStatusHandler myReadonlyStatusHandler;
    private boolean myNeedsSync;

    public DefaultRecipeExecutor(@NotNull RenderingContext context, boolean dryRun) {
        this.myReferences = new FindReferencesRecipeExecutor(context);
        this.myContext = context;
        this.myIO = dryRun ? new DryRunRecipeIO() : new RecipeIO();
        this.myReadonlyStatusHandler = ReadonlyStatusHandler.getInstance((Project)context.getProject());
    }

    @NotNull
    private static GradleBuildModel getBuildModel(@NotNull File buildFile, @NotNull Project project) {
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)buildFile, (boolean)true);
        if (virtualFile == null) {
            throw new RuntimeException("Failed to find " + buildFile.getPath());
        }
        return GradleBuildModel.parseBuildFile(virtualFile, project, project.getName());
    }

    @Override
    public void applyPlugin(@NotNull String plugin) {
        String name = plugin.trim();
        this.myReferences.applyPlugin(name);
        Project project = this.myContext.getProject();
        File buildFile = GradleUtil.getGradleBuildFilePath(this.myContext.getModuleRoot());
        if (project.isInitialized()) {
            GradleBuildModel buildModel = DefaultRecipeExecutor.getBuildModel(buildFile, project);
            if (buildModel.appliedPlugins().stream().noneMatch(x -> ((String)x.value()).equals(name))) {
                buildModel.applyPlugin(name);
                this.myIO.applyChanges(buildModel);
            }
        } else {
            String destinationContents = buildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(buildFile)) : "";
            String applyPluginStatement = "apply plugin: '" + name + "'";
            String result = destinationContents.isEmpty() ? applyPluginStatement : destinationContents + LINE_SEPARATOR + applyPluginStatement;
            try {
                this.myIO.writeFile(this, result, buildFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.myNeedsSync = true;
    }

    @Override
    public void addClasspath(@NotNull String mavenUrl) {
        mavenUrl = mavenUrl.trim();
        this.myReferences.addClasspath(mavenUrl);
        ArtifactDependencySpec toBeAddedDependency = ArtifactDependencySpec.create(mavenUrl);
        if (toBeAddedDependency == null) {
            throw new RuntimeException(mavenUrl + " is not a valid classpath dependency");
        }
        Project project = this.myContext.getProject();
        File rootBuildFile = GradleUtil.getGradleBuildFilePath(Projects.getBaseDirPath(project));
        if (project.isInitialized()) {
            GradleBuildModel buildModel = DefaultRecipeExecutor.getBuildModel(rootBuildFile, project);
            DependenciesModel buildscriptDependencies = buildModel.buildscript().dependencies();
            ArtifactDependencyModel targetDependencyModel = null;
            for (ArtifactDependencyModel dependencyModel : buildscriptDependencies.artifacts(CLASSPATH_CONFIGURATION_NAME)) {
                if (!toBeAddedDependency.equalsIgnoreVersion(ArtifactDependencySpec.create(dependencyModel))) continue;
                targetDependencyModel = dependencyModel;
            }
            if (targetDependencyModel == null) {
                buildscriptDependencies.addArtifact(CLASSPATH_CONFIGURATION_NAME, toBeAddedDependency);
            } else {
                GradleVersion existingDependencyVersion;
                GradleVersion toBeAddedDependencyVersion = GradleVersion.parse((String)Strings.nullToEmpty((String)toBeAddedDependency.version));
                if (toBeAddedDependencyVersion.compareTo(existingDependencyVersion = GradleVersion.parse((String)Strings.nullToEmpty((String)((String)targetDependencyModel.version().value())))) > 0) {
                    targetDependencyModel.setVersion(Strings.nullToEmpty((String)toBeAddedDependency.version));
                }
            }
            this.myIO.applyChanges(buildModel);
        } else {
            String destinationContents = rootBuildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(rootBuildFile)) : "";
            String result = this.myIO.mergeBuildFiles(DefaultRecipeExecutor.formatClasspath(mavenUrl), destinationContents, project, "");
            try {
                this.myIO.writeFile(this, result, rootBuildFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.myNeedsSync = true;
    }

    @NotNull
    private static String formatClasspath(@NotNull String dependency) {
        return "buildscript {" + LINE_SEPARATOR + "  dependencies {" + LINE_SEPARATOR + "    classpath '" + dependency + "'" + LINE_SEPARATOR + "  }" + LINE_SEPARATOR + "}" + LINE_SEPARATOR;
    }

    @Override
    public void addDependency(@NotNull String configuration, @NotNull String mavenUrl) {
        configuration = FmGetConfigurationNameMethod.convertConfiguration(this.getParamMap(), configuration);
        this.myReferences.addDependency(configuration, mavenUrl);
        SetMultimap dependencyList = (SetMultimap)this.getParamMap().get("dependenciesMultimap");
        dependencyList.put((Object)configuration, (Object)mavenUrl);
    }

    @Override
    public void addFilesToOpen(@NotNull File file) {
        this.myReferences.addFilesToOpen(file);
    }

    private void addWarning(@NotNull String warning) {
        this.myContext.getWarnings().add(warning);
    }

    @NotNull
    private Map<String, Object> getParamMap() {
        return this.myContext.getParamMap();
    }

    @NotNull
    Configuration getFreemarker() {
        return this.myContext.getFreemarkerConfiguration();
    }

    @Override
    public void copy(@NotNull File from, @NotNull File to) {
        try {
            this.copyTemplateResource(from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void instantiate(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        try {
            boolean isDirectory;
            boolean bl = isDirectory = from.getName().indexOf(46) == -1;
            if (isDirectory) {
                this.copyTemplateResource(from, to);
            } else {
                File sourceFile = this.myContext.getLoader().getSourceFile(from);
                File targetFile = this.getTargetFile(to);
                String content = FreemarkerUtils.processFreemarkerTemplate(this.myContext, sourceFile, null);
                if (targetFile.exists()) {
                    if (!this.compareTextFile(targetFile, content)) {
                        this.addFileAlreadyExistWarning(targetFile);
                    }
                } else {
                    this.myIO.writeFile(this, content, targetFile);
                    this.myReferences.addSourceFile(sourceFile);
                    this.myReferences.addTargetFile(targetFile);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void merge(@NotNull File from, @NotNull File to) throws FreemarkerUtils.TemplateProcessingException {
        try {
            String contents;
            String sourceText;
            String targetText = null;
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            if (!TemplateUtils.hasExtension(targetFile, ".xml") && !TemplateUtils.hasExtension(targetFile, ".gradle")) {
                throw new RuntimeException("Only XML or Gradle files can be merged at this point: " + targetFile);
            }
            if (targetFile.exists()) {
                VirtualFile toFile;
                ReadonlyStatusHandler.OperationStatus status;
                if (this.myContext.getProject().isInitialized() && (status = this.myReadonlyStatusHandler.ensureFilesWritable(new VirtualFile[]{toFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true)})).hasReadonlyFiles()) {
                    throw new FreemarkerUtils.TemplateUserVisibleException(String.format("Attempt to update file that is readonly: %1$s", targetFile.getAbsolutePath()));
                }
                targetText = this.readTextFile(targetFile);
            }
            if (targetText == null) {
                boolean instantiate = TemplateUtils.hasExtension(from, ".ftl");
                if (instantiate) {
                    this.instantiate(from, targetFile);
                } else {
                    this.copyTemplateResource(from, targetFile);
                }
                return;
            }
            if (TemplateUtils.hasExtension(from, ".ftl")) {
                sourceText = FreemarkerUtils.processFreemarkerTemplate(this.myContext, from, null);
            } else {
                sourceText = TemplateUtils.readTextFromDisk(sourceFile);
                if (sourceText == null) {
                    return;
                }
            }
            if (targetFile.getName().equals(GRADLE_PROJECT_SETTINGS_FILE)) {
                contents = RecipeMergeUtils.mergeGradleSettingsFile(sourceText, targetText);
                this.myNeedsSync = true;
            } else if (targetFile.getName().equals("build.gradle")) {
                String compileSdkVersion = (String)this.getParamMap().get("buildApiString");
                contents = this.myIO.mergeBuildFiles(sourceText, targetText, this.myContext.getProject(), compileSdkVersion);
                this.myNeedsSync = true;
            } else if (TemplateUtils.hasExtension(targetFile, ".xml")) {
                contents = RecipeMergeUtils.mergeXml(this.myContext, sourceText, targetText, targetFile);
            } else {
                throw new RuntimeException("Only XML or Gradle settings files can be merged at this point: " + targetFile);
            }
            this.myIO.writeFile(this, contents, targetFile);
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void append(@NotNull File from, @NotNull File to) {
        try {
            File sourceFile = this.myContext.getLoader().getSourceFile(from);
            File targetFile = this.getTargetFile(to);
            String sourceText = TemplateUtils.readTextFromDisk(sourceFile);
            if (sourceText == null) {
                return;
            }
            if (targetFile.exists()) {
                String targetContents = TemplateUtils.readTextFromDisk(targetFile);
                String resultContents = (targetContents == null ? "" : targetContents + LINE_SEPARATOR) + sourceText;
                this.myIO.writeFile(this, resultContents, targetFile);
            } else {
                this.myIO.writeFile(this, sourceText, targetFile);
            }
            this.myReferences.addSourceFile(sourceFile);
            this.myReferences.addTargetFile(targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void mkDir(@NotNull File at) {
        try {
            this.myIO.mkDir(this.getTargetFile(at));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateAndSync() {
        if (!this.myContext.getDependencies().isEmpty()) {
            try {
                this.mergeDependenciesIntoGradle();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Project project = this.myContext.getProject();
        if (this.myNeedsSync && this.myContext.performSync() && !project.isDefault() && Projects.isBuildWithGradle(project)) {
            this.myIO.requestSync(project);
        }
    }

    @Override
    public void pushFolder(@NotNull String folder) {
        try {
            this.myContext.getLoader().pushTemplateFolder(folder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void popFolder() {
        this.myContext.getLoader().popTemplateFolder();
    }

    @NotNull
    private File getTargetFile(@NotNull File file) throws IOException {
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.myContext.getOutputRoot(), file.getPath());
    }

    private void mergeDependenciesIntoGradle() throws Exception {
        boolean isInstantApp = (Boolean)this.getParamMap().getOrDefault("isInstantApp", false);
        String baseFeatureRoot = (String)this.getParamMap().getOrDefault("baseFeatureDir", "");
        if (!isInstantApp || Strings.isNullOrEmpty((String)baseFeatureRoot)) {
            this.writeDependencies(this.myContext.getModuleRoot(), x -> true);
        } else {
            String configName = FmGetConfigurationNameMethod.convertConfiguration(this.getParamMap(), "compile");
            if ("implementation".equals(configName)) {
                for (String apiDependency : this.myContext.getDependencies().removeAll((Object)"implementation")) {
                    this.myContext.getDependencies().put((Object)"api", (Object)apiDependency);
                }
                configName = "api";
            }
            String configuration = configName;
            this.writeDependencies(new File(baseFeatureRoot), x -> x.equals(configuration));
            this.writeDependencies(this.myContext.getModuleRoot(), x -> !x.equals(configuration));
        }
        this.myNeedsSync = true;
    }

    private void writeDependencies(File targetPath, Predicate<String> configurationFilter) throws IOException {
        File gradleBuildFile = GradleUtil.getGradleBuildFilePath(targetPath);
        String destinationContents = gradleBuildFile.exists() ? Strings.nullToEmpty((String)this.readTextFile(gradleBuildFile)) : "";
        Object buildApi = this.getParamMap().get("buildApi");
        String supportLibVersionFilter = buildApi != null ? buildApi.toString() : "";
        String result = this.myIO.mergeBuildFiles(this.formatDependencies(configurationFilter), destinationContents, this.myContext.getProject(), supportLibVersionFilter);
        this.myIO.writeFile(this, result, gradleBuildFile);
    }

    private String formatDependencies(Predicate<String> configurationFilter) {
        StringBuilder dependencies2 = new StringBuilder();
        dependencies2.append("dependencies {\n");
        for (Map.Entry dependency : this.myContext.getDependencies().entries()) {
            if (!configurationFilter.test((String)dependency.getKey())) continue;
            dependencies2.append("  ").append((String)dependency.getKey()).append(" ");
            String dependencyValue = (String)dependency.getValue();
            boolean isInterpolated = dependencyValue.contains("$");
            dependencies2.append(isInterpolated ? (char)'\"' : '\'').append(dependencyValue).append(isInterpolated ? (char)'\"' : '\'').append("\n");
        }
        dependencies2.append("}\n");
        return dependencies2.toString();
    }

    private void copyDirectory(final @NotNull VirtualFile src, final @NotNull File dest) throws IOException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)src, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                try {
                    return DefaultRecipeExecutor.this.copyFile(file, src, dest);
                }
                catch (IOException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, IOException.class);
    }

    private void copyTemplateResource(@NotNull File from, @NotNull File to) throws IOException {
        File destPath;
        File source = this.myContext.getLoader().getSourceFile(from);
        File target = this.getTargetFile(to);
        VirtualFile sourceFile = VfsUtil.findFileByIoFile((File)source, (boolean)true);
        assert (sourceFile != null) : source;
        sourceFile.refresh(false, false);
        File file = destPath = source.isDirectory() ? target : target.getParentFile();
        if (source.isDirectory()) {
            this.copyDirectory(sourceFile, destPath);
        } else if (target.exists()) {
            if (!this.compareFile(sourceFile, target)) {
                this.addFileAlreadyExistWarning(target);
            }
        } else {
            Document document = FileDocumentManager.getInstance().getDocument(sourceFile);
            if (document != null) {
                this.myIO.writeFile(this, document.getText(), target);
            } else {
                this.myIO.copyFile(this, sourceFile, destPath, target.getName());
            }
            this.myReferences.addSourceFile(source);
            this.myReferences.addTargetFile(target);
        }
    }

    private boolean copyFile(VirtualFile file, VirtualFile src, File destinationFile) throws IOException {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)src, (char)File.separatorChar);
        if (relativePath == null) {
            throw new RuntimeException(String.format("%1$s is not a child of %2$s", file.getPath(), src));
        }
        if (file.isDirectory()) {
            this.myIO.mkDir(new File(destinationFile, relativePath));
        } else {
            File target = new File(destinationFile, relativePath);
            if (target.exists()) {
                if (!this.compareFile(file, target)) {
                    this.addFileAlreadyExistWarning(target);
                }
            } else {
                this.myIO.copyFile(this, file, target);
                this.myReferences.addSourceFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
                this.myReferences.addTargetFile(target);
            }
        }
        return true;
    }

    private String readTextFile(@NotNull File file) {
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(file);
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    private String readTextFile(@NotNull VirtualFile file) {
        if (Boolean.TRUE.equals(this.myContext.getParamMap().get("isNewProject"))) {
            return TemplateUtils.readTextFromDisk(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        }
        return TemplateUtils.readTextFromDocument(this.myContext.getProject(), file);
    }

    public boolean compareFile(@NotNull VirtualFile sourceVFile, @NotNull File targetFile) throws IOException {
        VirtualFile targetVFile = VfsUtil.findFileByIoFile((File)targetFile, (boolean)true);
        if (targetVFile == null) {
            return false;
        }
        if (sourceVFile.getFileType().isBinary()) {
            byte[] source = sourceVFile.contentsToByteArray();
            byte[] target = targetVFile.contentsToByteArray();
            return Arrays.equals(source, target);
        }
        String source = this.readTextFile(sourceVFile);
        String target = this.readTextFile(targetVFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)source, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    public boolean compareTextFile(@NotNull File targetFile, @NotNull String content) {
        String target = this.readTextFile(targetFile);
        ComparisonManager comparisonManager = ComparisonManager.getInstance();
        return comparisonManager.isEquals((CharSequence)content, (CharSequence)target, ComparisonPolicy.IGNORE_WHITESPACES);
    }

    private void addFileAlreadyExistWarning(@NotNull File targetFile) {
        this.addWarning(String.format("The following file could not be created since it already exists: %1$s", targetFile.getName()));
    }

    private static class DryRunRecipeIO
    extends RecipeIO {
        private DryRunRecipeIO() {
        }

        @Override
        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(to.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(toFile.getParentFile());
        }

        @Override
        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @Nullable String newName) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(toFileDir);
        }

        @Override
        public void mkDir(@NotNull File directory) throws IOException {
            TemplateUtils.checkDirectoryIsWriteable(directory);
        }

        @Override
        public void applyChanges(@NotNull GradleBuildModel buildModel) {
        }

        @Override
        public String mergeBuildFiles(@NotNull String dependencies2, @NotNull String destinationContents, Project project, String compileSdkVersion) {
            return destinationContents;
        }

        @Override
        public void requestSync(@NotNull Project project) {
        }
    }

    private static class RecipeIO {
        private RecipeIO() {
        }

        public void writeFile(@NotNull Object requestor, @Nullable String contents, @NotNull File to) throws IOException {
            TemplateUtils.checkedCreateDirectoryIfMissing(to.getParentFile());
            TemplateUtils.writeTextFile(this, contents, to);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFile) throws IOException {
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFile.getParentFile());
            VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)toDir);
        }

        public void copyFile(Object requestor, @NotNull VirtualFile file, @NotNull File toFileDir, @NotNull String newName) throws IOException {
            VirtualFile toDir = TemplateUtils.checkedCreateDirectoryIfMissing(toFileDir);
            VfsUtilCore.copyFile((Object)requestor, (VirtualFile)file, (VirtualFile)toDir, (String)newName);
        }

        public void mkDir(@NotNull File directory) throws IOException {
            TemplateUtils.checkedCreateDirectoryIfMissing(directory);
        }

        public void applyChanges(@NotNull GradleBuildModel buildModel) {
            buildModel.applyChanges();
        }

        public String mergeBuildFiles(@NotNull String dependencies2, @NotNull String destinationContents, @NotNull Project project, @Nullable String supportLibVersionFilter) {
            BuildSystemService buildSystemService = BuildSystemService.getInstance(project);
            assert (buildSystemService != null);
            return buildSystemService.mergeBuildFiles(dependencies2, destinationContents, project, supportLibVersionFilter);
        }

        public void requestSync(@NotNull Project project) {
            BuildSystemService buildSystemService = BuildSystemService.getInstance(project);
            assert (buildSystemService != null);
            buildSystemService.syncProject(project);
        }
    }
}

