/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.junit.JavaRuntimeConfigurationProducerBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;

public class AndroidTestConfigurationProducer
extends JavaRunConfigurationProducerBase<AndroidTestRunConfiguration> {
    public AndroidTestConfigurationProducer() {
        super((ConfigurationType)AndroidTestRunConfigurationType.getInstance());
    }

    private boolean setupAllInPackageConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiPackage p = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)element);
        if (p == null) {
            return false;
        }
        String packageName = p.getQualifiedName();
        this.setupConfiguration(configuration, (PsiElement)p, context, sourceElement);
        configuration.TESTING_TYPE = !packageName.isEmpty() ? 1 : 0;
        configuration.PACKAGE_NAME = packageName;
        configuration.setGeneratedName();
        return true;
    }

    private boolean setupClassConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiClass elementClass = AndroidPsiUtils.getPsiParentOfType(element, PsiClass.class, false);
        while (elementClass != null) {
            if (JUnitUtil.isTestClass((PsiClass)elementClass)) {
                this.setupConfiguration(configuration, (PsiElement)elementClass, context, sourceElement);
                configuration.TESTING_TYPE = 2;
                configuration.CLASS_NAME = elementClass.getQualifiedName();
                configuration.setGeneratedName();
                return true;
            }
            elementClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementClass, PsiClass.class);
        }
        return false;
    }

    private boolean setupMethodConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiMethod elementMethod = AndroidPsiUtils.getPsiParentOfType(element, PsiMethod.class, false);
        while (elementMethod != null) {
            if (AndroidTestConfigurationProducer.isTestMethod(elementMethod)) {
                PsiClass c = elementMethod.getContainingClass();
                this.setupConfiguration(configuration, (PsiElement)elementMethod, context, sourceElement);
                assert (c != null);
                configuration.TESTING_TYPE = 3;
                configuration.CLASS_NAME = c.getQualifiedName();
                configuration.METHOD_NAME = elementMethod.getName();
                configuration.setGeneratedName();
                return true;
            }
            elementMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)elementMethod, PsiMethod.class);
        }
        return false;
    }

    private void setupConfiguration(AndroidTestRunConfiguration configuration, PsiElement element, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Module module = AndroidUtils.getAndroidModule(context);
        if (module == null) {
            return;
        }
        sourceElement.set((Object)element);
        this.setupConfigurationModule(context, configuration);
        TargetSelectionMode targetSelectionMode = AndroidUtils.getDefaultTargetSelectionMode(module, AndroidTestRunConfigurationType.getInstance(), AndroidRunConfigurationType.getInstance());
        if (targetSelectionMode != null) {
            configuration.getDeployTargetContext().setTargetSelectionMode(targetSelectionMode);
        }
    }

    private static boolean isTestMethod(PsiMethod method) {
        PsiClass testClass = method.getContainingClass();
        if (testClass != null && JUnitUtil.isTestClass((PsiClass)testClass)) {
            return new JUnitUtil.TestMethodFilter(testClass).value(method);
        }
        return false;
    }

    protected boolean setupConfigurationFromContext(AndroidTestRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        Module module = AndroidUtils.getAndroidModule(context);
        if (module == null) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return false;
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel != null) {
            if (facet.getProjectType() != 2 && androidModel.getSelectedVariant().getAndroidTestArtifact() == null) {
                return false;
            }
            TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(module);
            if (testScopes == null) {
                return false;
            }
            VirtualFile virtualFile = null;
            if (element instanceof PsiDirectory) {
                virtualFile = ((PsiDirectory)element).getVirtualFile();
            } else {
                PsiFile psiFile = element.getContainingFile();
                if (psiFile != null) {
                    virtualFile = psiFile.getVirtualFile();
                }
            }
            if (virtualFile == null) {
                return false;
            }
            if (!testScopes.isAndroidTestSource(virtualFile)) {
                return false;
            }
        }
        AndroidTestConfigurationProducer.setupInstrumentationTestRunner(configuration, facet);
        if (this.setupAllInPackageConfiguration(configuration, element, context, sourceElement)) {
            return true;
        }
        if (this.setupMethodConfiguration(configuration, element, context, sourceElement)) {
            return true;
        }
        return this.setupClassConfiguration(configuration, element, context, sourceElement);
    }

    private static void setupInstrumentationTestRunner(@NotNull AndroidTestRunConfiguration configuration, @NotNull AndroidFacet facet) {
        if (!GradleProjectInfo.getInstance(configuration.getProject()).isBuildWithGradle()) {
            configuration.INSTRUMENTATION_RUNNER_CLASS = StringUtil.notNullize((String)AndroidTestRunConfiguration.findInstrumentationRunner(facet));
        }
    }

    public boolean isConfigurationFromContext(AndroidTestRunConfiguration configuration, ConfigurationContext context) {
        Location location = context.getLocation();
        Module contextModule = AndroidUtils.getAndroidModule(context);
        if (contextModule == null || location == null) {
            return false;
        }
        if ((location = JavaExecutionUtil.stepIntoSingleClass((Location)location)) == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        VirtualFile directoryOrFile = element instanceof PsiDirectory ? ((PsiDirectory)element).getVirtualFile() : element.getContainingFile().getVirtualFile();
        TestArtifactSearchScopes testScopes = TestArtifactSearchScopes.get(contextModule);
        if (directoryOrFile != null && testScopes != null && !testScopes.isAndroidTestSource(directoryOrFile)) {
            return false;
        }
        PsiPackage psiPackage = JavaRuntimeConfigurationProducerBase.checkPackage((PsiElement)element);
        String packageName = psiPackage == null ? null : psiPackage.getQualifiedName();
        PsiClass elementClass = AndroidPsiUtils.getPsiParentOfType(element, PsiClass.class, false);
        String className = elementClass == null ? null : elementClass.getQualifiedName();
        PsiMethod elementMethod = AndroidPsiUtils.getPsiParentOfType(element, PsiMethod.class, false);
        String methodName = elementMethod == null ? null : elementMethod.getName();
        Module moduleInConfig = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        if (!Comparing.equal((Object)contextModule, (Object)moduleInConfig)) {
            return false;
        }
        switch (configuration.TESTING_TYPE) {
            case 0: {
                return psiPackage != null && packageName.isEmpty();
            }
            case 1: {
                return packageName != null && packageName.equals(configuration.PACKAGE_NAME);
            }
            case 2: {
                return elementMethod == null && className != null && className.equals(configuration.CLASS_NAME);
            }
            case 3: {
                return methodName != null && methodName.equals(configuration.METHOD_NAME) && className != null && className.equals(configuration.CLASS_NAME);
            }
        }
        return false;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Project project = self.getConfiguration().getProject();
        if (!GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            return false;
        }
        return other.isProducedBy(JUnitConfigurationProducer.class);
    }
}

