/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.builder.model.TestOptions;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.OnDeviceOrchestratorRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.GradleApkProvider;
import com.android.tools.idea.run.NonGradleApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.TestRunParameters;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestConsoleProperties;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestListener;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.android.dom.manifest.Instrumentation;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidTestRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider {
    private static final Logger LOG = Logger.getInstance(AndroidTestRunConfiguration.class);
    public static final int TEST_ALL_IN_MODULE = 0;
    public static final int TEST_ALL_IN_PACKAGE = 1;
    public static final int TEST_CLASS = 2;
    public static final int TEST_METHOD = 3;
    public int TESTING_TYPE = 0;
    public String INSTRUMENTATION_RUNNER_CLASS = "";
    public String METHOD_NAME = "";
    public String CLASS_NAME = "";
    public String PACKAGE_NAME = "";
    public String EXTRA_OPTIONS = "";

    public AndroidTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory, true);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet) {
        if (!facet.requiresAndroidModel()) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel == null) {
            return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
        }
        IdeAndroidArtifact testArtifact = androidModel.getSelectedVariant().getAndroidTestArtifact();
        String testTask = testArtifact != null ? testArtifact.getAssembleTaskName() : null;
        return new Pair((Object)(testTask != null ? 1 : 0), (Object)AndroidBundle.message("android.cannot.run.library.project.in.this.buildtype", new Object[0]));
    }

    public boolean isGeneratedName() {
        String name = this.getName();
        if (!(this.TESTING_TYPE != 2 && this.TESTING_TYPE != 3 || this.CLASS_NAME != null && !this.CLASS_NAME.isEmpty())) {
            return JavaExecutionUtil.isNewName((String)name);
        }
        if (this.TESTING_TYPE == 3 && (this.METHOD_NAME == null || this.METHOD_NAME.isEmpty())) {
            return JavaExecutionUtil.isNewName((String)name);
        }
        return Comparing.equal((String)name, (String)this.suggestedName());
    }

    public String suggestedName() {
        if (this.TESTING_TYPE == 1) {
            return ExecutionBundle.message((String)"test.in.scope.presentable.text", (Object[])new Object[]{this.PACKAGE_NAME});
        }
        if (this.TESTING_TYPE == 2) {
            return ProgramRunnerUtil.shortenName((String)JavaExecutionUtil.getShortClassName((String)this.CLASS_NAME), (int)0);
        }
        if (this.TESTING_TYPE == 3) {
            return ProgramRunnerUtil.shortenName((String)this.METHOD_NAME, (int)2) + "()";
        }
        return ExecutionBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet) {
        int count;
        ArrayList errors = Lists.newArrayList();
        Module module = facet.getModule();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        switch (this.TESTING_TYPE) {
            case 1: {
                PsiPackage testPackage = facade.findPackage(this.PACKAGE_NAME);
                if (testPackage != null) break;
                errors.add(ValidationError.warning(ExecutionBundle.message((String)"package.does.not.exist.error.message", (Object[])new Object[]{this.PACKAGE_NAME})));
                break;
            }
            case 2: {
                PsiClass testClass = null;
                try {
                    testClass = ((JavaRunConfigurationModule)this.getConfigurationModule()).checkModuleAndClassName(this.CLASS_NAME, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
                }
                catch (RuntimeConfigurationException e) {
                    errors.add(ValidationError.fromException(e));
                }
                if (testClass == null || JUnitUtil.isTestClass((PsiClass)testClass)) break;
                errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                break;
            }
            case 3: {
                errors.addAll(this.checkTestMethod());
            }
        }
        if (GradleProjectInfo.getInstance(this.getProject()).isBuildWithGradle() && !this.INSTRUMENTATION_RUNNER_CLASS.isEmpty() && facade.findClass(this.INSTRUMENTATION_RUNNER_CLASS, module.getModuleWithDependenciesAndLibrariesScope(true)) == null) {
            errors.add(ValidationError.fatal(AndroidBundle.message("instrumentation.runner.class.not.specified.error", new Object[0])));
        }
        AndroidFacetConfiguration configuration = (AndroidFacetConfiguration)facet.getConfiguration();
        if (!facet.requiresAndroidModel() && !configuration.getState().PACK_TEST_CODE && (count = AndroidTestRunConfiguration.getTestSourceRootCount(module)) > 0) {
            String shortMessage = "Test code not included into APK";
            String fixMessage = "Code and resources under test source " + (count > 1 ? "roots" : "root") + " aren't included into debug APK.\nWould you like to include them and recompile " + module.getName() + " module?\n(You may change this option in Android facet settings later)";
            Runnable quickFix = () -> {
                int result = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)fixMessage, (String)"Test code not included into APK", (Icon)Messages.getQuestionIcon());
                if (result == 0) {
                    configuration.getState().PACK_TEST_CODE = true;
                }
            };
            errors.add(ValidationError.fatal("Test code not included into APK", quickFix));
        }
        return errors;
    }

    @Override
    @NotNull
    protected ApkProvider getApkProvider(@NotNull AndroidFacet facet, @NotNull ApplicationIdProvider applicationIdProvider) {
        if (facet.getAndroidModel() != null && facet.getAndroidModel() instanceof AndroidModuleModel) {
            return new GradleApkProvider(facet, applicationIdProvider, this.myOutputProvider, true);
        }
        return new NonGradleApkProvider(facet, applicationIdProvider, null);
    }

    private static int getTestSourceRootCount(@NotNull Module module) {
        ModuleRootManager manager = ModuleRootManager.getInstance((Module)module);
        return manager.getSourceRoots(true).length - manager.getSourceRoots(false).length;
    }

    private List<ValidationError> checkTestMethod() {
        PsiClass testClass;
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            testClass = configurationModule.checkModuleAndClassName(this.CLASS_NAME, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        }
        catch (RuntimeConfigurationException e) {
            return ImmutableList.of((Object)ValidationError.fromException(e));
        }
        ArrayList errors = Lists.newArrayList();
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            errors.add(ValidationError.warning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{this.CLASS_NAME})));
        }
        if (this.METHOD_NAME == null || this.METHOD_NAME.trim().isEmpty()) {
            errors.add(ValidationError.fatal(ExecutionBundle.message((String)"method.name.not.specified.error.message", (Object[])new Object[0])));
        }
        JUnitUtil.TestMethodFilter filter = new JUnitUtil.TestMethodFilter(testClass);
        boolean found = false;
        boolean testAnnotated = false;
        for (PsiMethod method : testClass.findMethodsByName(this.METHOD_NAME, true)) {
            if (filter.value(method)) {
                found = true;
            }
            if (!JUnitUtil.isTestAnnotated((PsiMethod)method)) continue;
            testAnnotated = true;
        }
        if (!found) {
            errors.add(ValidationError.warning(ExecutionBundle.message((String)"test.method.doesnt.exist.error.message", (Object[])new Object[]{this.METHOD_NAME})));
        }
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)testClass, (String)"org.junit.runner.RunWith", (boolean)true) && !testAnnotated) {
            try {
                PsiClass testCaseClass = JUnitUtil.getTestCaseClass((Module)configurationModule.getModule());
                if (!testClass.isInheritor(testCaseClass, true)) {
                    errors.add(ValidationError.fatal(ExecutionBundle.message((String)"class.isnt.inheritor.of.testcase.error.message", (Object[])new Object[]{this.CLASS_NAME})));
                }
            }
            catch (JUnitUtil.NoJUnitException e) {
                errors.add(ValidationError.warning(ExecutionBundle.message((String)AndroidBundle.message("cannot.find.testcase.error", new Object[0]), (Object[])new Object[0])));
            }
        }
        return errors;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        AndroidRunConfigurationEditor<AndroidTestRunConfiguration> editor = new AndroidRunConfigurationEditor<AndroidTestRunConfiguration>(project, (Predicate<AndroidFacet>)((Predicate)facet -> facet != null && (Boolean)this.supportsRunningLibraryProjects((AndroidFacet)((Object)facet)).getFirst() != false), this);
        editor.setConfigurationSpecificEditor(new TestRunParameters(project, editor.getModuleSelector()));
        return editor;
    }

    @Override
    @NotNull
    protected ConsoleProvider getConsoleProvider() {
        return (parent, handler, executor) -> {
            AndroidTestConsoleProperties properties = new AndroidTestConsoleProperties((RunConfiguration)this, executor);
            BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole((String)"Android", (ProcessHandler)handler, (TestConsoleProperties)properties);
            Disposer.register((Disposable)parent, (Disposable)consoleView);
            return consoleView;
        };
    }

    @Override
    protected boolean supportMultipleDevices() {
        return false;
    }

    @Override
    public boolean monitorRemoteProcess() {
        return false;
    }

    @Override
    @Nullable
    protected LaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider applicationIdProvider, @NotNull AndroidFacet facet, boolean waitForDebugger, @NotNull LaunchStatus launchStatus) {
        String testPackage;
        String runner = StringUtil.isEmpty((String)this.INSTRUMENTATION_RUNNER_CLASS) || GradleProjectInfo.getInstance(this.getProject()).isBuildWithGradle() ? AndroidTestRunConfiguration.findInstrumentationRunner(facet) : this.INSTRUMENTATION_RUNNER_CLASS;
        Map<String, String> runnerArguments = AndroidTestRunConfiguration.getRunnerArguments(facet);
        try {
            testPackage = applicationIdProvider.getTestPackageName();
            if (testPackage == null) {
                launchStatus.terminateLaunch("Unable to determine test package name");
                return null;
            }
        }
        catch (ApkProvisionException e) {
            launchStatus.terminateLaunch("Unable to determine test package name");
            return null;
        }
        AndroidModuleModel moduleModel = AndroidModuleModel.get(facet);
        IdeAndroidArtifact testArtifact = null;
        if (moduleModel != null) {
            testArtifact = moduleModel.getArtifactForAndroidTest();
        }
        return new MyApplicationLaunchTask(runner, testPackage, waitForDebugger, runnerArguments, testArtifact);
    }

    @Nullable
    public static String findInstrumentationRunner(@NotNull AndroidFacet facet) {
        IdeVariant selectedVariant;
        String testRunner;
        String runner = AndroidTestRunConfiguration.getRunnerFromManifest(facet);
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (runner == null && androidModel != null && (testRunner = (selectedVariant = androidModel.getSelectedVariant()).getMergedFlavor().getTestInstrumentationRunner()) != null) {
            runner = testRunner;
        }
        return runner;
    }

    @NotNull
    public static Map<String, String> getRunnerArguments(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel != null) {
            return new HashMap<String, String>(androidModel.getSelectedVariant().getMergedFlavor().getTestInstrumentationRunnerArguments());
        }
        return Collections.emptyMap();
    }

    @Nullable
    private static String getRunnerFromManifest(@NotNull AndroidFacet facet) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)ApplicationManager.getApplication().runReadAction(() -> AndroidTestRunConfiguration.getRunnerFromManifest(facet));
        }
        Manifest manifest = facet.getManifest();
        if (manifest != null) {
            for (Instrumentation instrumentation : manifest.getInstrumentations()) {
                PsiClass instrumentationClass;
                if (instrumentation == null || (instrumentationClass = (PsiClass)instrumentation.getInstrumentationClass().getValue()) == null) continue;
                return instrumentationClass.getQualifiedName();
            }
        }
        return null;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (element instanceof PsiPackage) {
            String pkgName = ((PsiPackage)element).getQualifiedName();
            if (this.TESTING_TYPE == 1 && !Objects.equals(pkgName, this.PACKAGE_NAME)) {
                return null;
            }
            if (this.TESTING_TYPE != 1 && !Objects.equals(pkgName, StringUtil.getPackageName((String)this.CLASS_NAME))) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiPackage) {
                        String newPkgName = ((PsiPackage)newElement).getQualifiedName();
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = newPkgName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), newPkgName);
                        }
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiPackage) {
                        if (AndroidTestRunConfiguration.this.TESTING_TYPE == 1) {
                            AndroidTestRunConfiguration.this.PACKAGE_NAME = oldQualifiedName;
                        } else {
                            AndroidTestRunConfiguration.this.CLASS_NAME = AndroidTestRunConfiguration.this.CLASS_NAME.replace(StringUtil.getPackageName((String)AndroidTestRunConfiguration.this.CLASS_NAME), oldQualifiedName);
                        }
                    }
                }
            };
        }
        if ((this.TESTING_TYPE == 2 || this.TESTING_TYPE == 3) && element instanceof PsiClass) {
            if (!StringUtil.equals((CharSequence)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)element)), (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)((PsiClass)newElement));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiClass) {
                        AndroidTestRunConfiguration.this.CLASS_NAME = oldQualifiedName;
                    }
                }
            };
        }
        if (this.TESTING_TYPE == 3 && element instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (!StringUtil.equals((CharSequence)psiMethod.getName(), (CharSequence)this.METHOD_NAME)) {
                return null;
            }
            PsiClass psiClass = psiMethod.getContainingClass();
            if (psiClass == null) {
                return null;
            }
            String fqName = psiClass.getQualifiedName();
            if (fqName != null && !StringUtil.equals((CharSequence)fqName, (CharSequence)this.CLASS_NAME)) {
                return null;
            }
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = ((PsiMethod)newElement).getName();
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement instanceof PsiMethod) {
                        AndroidTestRunConfiguration.this.METHOD_NAME = oldQualifiedName;
                    }
                }
            };
        }
        return null;
    }

    class MyApplicationLaunchTask
    implements LaunchTask {
        @Nullable
        private final String myInstrumentationTestRunner;
        @NotNull
        private final String myTestApplicationId;
        private final boolean myWaitForDebugger;
        @NotNull
        private final Map<String, String> myInstrumentationTestRunnerArguments;
        @Nullable
        private final IdeAndroidArtifact myArtifact;

        public MyApplicationLaunchTask(@NotNull String runner, String testPackage, @NotNull boolean waitForDebugger, @Nullable Map<String, String> arguments, IdeAndroidArtifact artifact) {
            this.myInstrumentationTestRunner = runner;
            this.myWaitForDebugger = waitForDebugger;
            this.myTestApplicationId = testPackage;
            this.myInstrumentationTestRunnerArguments = arguments;
            this.myArtifact = artifact;
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Launching instrumentation runner";
        }

        @Override
        public int getDuration() {
            return 2;
        }

        @NotNull
        public RemoteAndroidTestRunner getRemoteAndroidTestRunner(@Nullable IdeAndroidArtifact artifact, @NotNull IDevice device) {
            return artifact != null && artifact.getTestOptions() != null && TestOptions.Execution.ANDROID_TEST_ORCHESTRATOR.equals((Object)artifact.getTestOptions().getExecution()) ? new OnDeviceOrchestratorRemoteAndroidTestRunner(this.myTestApplicationId, this.myInstrumentationTestRunner, (IShellEnabledDevice)device) : new RemoteAndroidTestRunner(this.myTestApplicationId, this.myInstrumentationTestRunner, (IShellEnabledDevice)device);
        }

        @Override
        public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
            printer.stdout("Running tests\n");
            RemoteAndroidTestRunner runner = this.getRemoteAndroidTestRunner(this.myArtifact, device);
            switch (AndroidTestRunConfiguration.this.TESTING_TYPE) {
                case 1: {
                    runner.setTestPackageName(AndroidTestRunConfiguration.this.PACKAGE_NAME);
                    break;
                }
                case 2: {
                    runner.setClassName(AndroidTestRunConfiguration.this.CLASS_NAME);
                    break;
                }
                case 3: {
                    runner.setMethodName(AndroidTestRunConfiguration.this.CLASS_NAME, AndroidTestRunConfiguration.this.METHOD_NAME);
                }
            }
            runner.setDebug(this.myWaitForDebugger);
            runner.setRunOptions(AndroidTestRunConfiguration.this.EXTRA_OPTIONS);
            for (Map.Entry<String, String> entry : this.myInstrumentationTestRunnerArguments.entrySet()) {
                runner.addInstrumentationArg(entry.getKey(), entry.getValue());
            }
            printer.stdout("$ adb shell " + runner.getAmInstrumentCommand());
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    runner.run(new ITestRunListener[]{new AndroidTestListener(launchStatus, printer)});
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                    printer.stderr("Error: Unexpected exception while running tests: " + e);
                }
            });
            return true;
        }
    }
}

