/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.instrumented;

import com.android.tools.idea.run.AndroidRunConfigurationType;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidTestRunConfigurationType
implements ConfigurationType {
    private static final Icon ANDROID_TEST_ICON;
    private final ConfigurationFactory myFactory = new AndroidRunConfigurationType.AndroidRunConfigurationFactory(this){

        @Override
        public RunConfiguration createTemplateConfiguration(Project project) {
            return new AndroidTestRunConfiguration(project, this);
        }
    };

    public static AndroidTestRunConfigurationType getInstance() {
        return (AndroidTestRunConfigurationType)ConfigurationTypeUtil.findConfigurationType(AndroidTestRunConfigurationType.class);
    }

    public String getDisplayName() {
        return AndroidBundle.message("android.test.run.configuration.type.name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return AndroidBundle.message("android.test.run.configuration.type.description", new Object[0]);
    }

    public Icon getIcon() {
        return ANDROID_TEST_ICON;
    }

    @NotNull
    public String getId() {
        return "AndroidTestRunConfigurationType";
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    public ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    static {
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(AndroidIcons.AndroidModule, 0);
        icon.setIcon(AllIcons.Nodes.JunitTestMark, 1);
        ANDROID_TEST_ICON = icon;
    }
}

