/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.intellij.execution.configuration.ConfigurationFactoryEx;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.ui.LayeredIcon;
import icons.AndroidIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AndroidJUnitConfigurationType
extends JUnitConfigurationType {
    private static final Icon ANDROID_TEST_ICON;
    private static final String ANDROID_JUNIT_DESCRIPTION = "Android JUnit test configuration";
    private static final String ANDROID_JUNIT_NAME = "Android JUnit";
    private static final String ANDROID_JUNIT_ID = "AndroidJUnit";
    private final ConfigurationFactory myFactory = new ConfigurationFactoryEx((ConfigurationType)this){

        @NotNull
        public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
            return new AndroidJUnitConfiguration("", project, (ConfigurationFactory)this);
        }

        public void onNewConfigurationCreated(@NotNull RunConfiguration configuration) {
            ((ModuleBasedConfiguration)configuration).onNewConfigurationCreated();
        }
    };

    public String getDisplayName() {
        return ANDROID_JUNIT_NAME;
    }

    public String getConfigurationTypeDescription() {
        return ANDROID_JUNIT_DESCRIPTION;
    }

    public Icon getIcon() {
        return IdeInfo.getInstance().isAndroidStudio() ? AllIcons.RunConfigurations.Junit : ANDROID_TEST_ICON;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.myFactory};
    }

    @NotNull
    public String getId() {
        return ANDROID_JUNIT_ID;
    }

    @NotNull
    public static AndroidJUnitConfigurationType getInstance() {
        return (AndroidJUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(AndroidJUnitConfigurationType.class);
    }

    static {
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(AndroidIcons.AndroidModule, 0);
        icon.setIcon(AllIcons.Nodes.JunitTestMark, 1);
        ANDROID_TEST_ICON = icon;
    }
}

