/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.junit;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.NotNull;

public class AndroidJUnitConfigurations {
    public static boolean shouldUseAndroidJUnitConfigurations(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Project project = self.getConfiguration().getProject();
        return IdeInfo.getInstance().isAndroidStudio() || AndroidProjectInfo.getInstance(project).requiresAndroidModel();
    }

    public static boolean isFromContext(@NotNull JUnitConfiguration unitConfiguration, @NotNull ConfigurationContext context, @NotNull ConfigurationFactory configurationFactory) {
        String vmParameters;
        String paramSetName;
        if (((PatternConfigurationProducer)RunConfigurationProducer.getInstance(PatternConfigurationProducer.class)).isMultipleElementsSelected(context)) {
            return false;
        }
        RunConfiguration predefinedConfiguration = context.getOriginalConfiguration((ConfigurationType)AndroidJUnitConfigurationType.getInstance());
        Location contextLocation = context.getLocation();
        String string = paramSetName = contextLocation instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)contextLocation).getParamSetName() : null;
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        PsiClass testClass = JUnitUtil.getTestClass((PsiElement)element);
        PsiMethod testMethod = JUnitUtil.getTestMethod((PsiElement)element, (boolean)false);
        Object testPackage = element instanceof PsiPackage ? (PsiPackage)element : (element instanceof PsiDirectory ? JavaDirectoryService.getInstance().getPackage((PsiDirectory)element) : null);
        PsiDirectory testDir = element instanceof PsiDirectory ? (PsiDirectory)element : null;
        RunnerAndConfigurationSettings template = RunManager.getInstance((Project)location.getProject()).getConfigurationTemplate(configurationFactory);
        Module predefinedModule = ((JavaRunConfigurationModule)((JUnitConfiguration)template.getConfiguration()).getConfigurationModule()).getModule();
        String string2 = vmParameters = predefinedConfiguration instanceof JUnitConfiguration ? ((JUnitConfiguration)predefinedConfiguration).getVMParameters() : null;
        if (vmParameters != null && !Comparing.strEqual((String)vmParameters, (String)unitConfiguration.getVMParameters())) {
            return false;
        }
        if (paramSetName != null && !Comparing.strEqual((String)paramSetName, (String)unitConfiguration.getProgramParameters())) {
            return false;
        }
        TestObject testobject = unitConfiguration.getTestObject();
        if (testobject != null && testobject.isConfiguredByElement(unitConfiguration, testClass, testMethod, testPackage, testDir)) {
            Module configurationModule = ((JavaRunConfigurationModule)unitConfiguration.getConfigurationModule()).getModule();
            if (Comparing.equal((Object)location.getModule(), (Object)configurationModule)) {
                return true;
            }
            if (Comparing.equal((Object)predefinedModule, (Object)configurationModule)) {
                return true;
            }
        }
        return false;
    }
}

