/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeDependencies;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.utils.FileUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludedRoots {
    @NotNull
    private final Module myModule;
    @NotNull
    private final ExcludedModules myExcludedModules;
    private final boolean myAndroidTest;
    @NotNull
    private final Set<File> myExcludedRoots = new HashSet<File>();
    @NotNull
    private final Set<String> myIncludedRootNames = new HashSet<String>();

    ExcludedRoots(@NotNull Module module, @NotNull ExcludedModules excludedModules, @NotNull DependencySet dependenciesToExclude, @NotNull DependencySet dependenciesToInclude, boolean isAndroidTest) {
        this.myModule = module;
        this.myExcludedModules = excludedModules;
        this.myAndroidTest = isAndroidTest;
        this.addFolderPathsFromExcludedModules();
        this.addRemainingModelsIfNecessary();
        for (LibraryDependency libraryDependency : dependenciesToInclude.onLibraries()) {
            File[] binaryPaths;
            for (File binaryPath : binaryPaths = libraryDependency.getPaths(LibraryDependency.PathType.BINARY)) {
                this.myIncludedRootNames.add(binaryPath.getName());
            }
        }
        this.addLibraryPaths(dependenciesToExclude);
        this.removeLibraryPaths(dependenciesToInclude);
    }

    private void addFolderPathsFromExcludedModules() {
        for (Module module : this.myExcludedModules) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            for (ContentEntry entry : rootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(sourceFolder.getUrl()));
                }
                CompilerModuleExtension compiler = (CompilerModuleExtension)rootManager.getModuleExtension(CompilerModuleExtension.class);
                String url = compiler.getCompilerOutputUrl();
                if (!StringUtil.isNotEmpty((String)url)) continue;
                this.myExcludedRoots.add(ExcludedRoots.urlToFilePath(url));
            }
            AndroidModuleModel androidModuleModel = AndroidModuleModel.get(module);
            if (androidModuleModel == null) continue;
            this.myExcludedRoots.add(androidModuleModel.getMainArtifact().getJavaResourcesFolder());
        }
    }

    @Nullable
    private static File urlToFilePath(@NotNull String url) {
        if (url.startsWith("jar://")) {
            return FilePaths.getJarFromJarUrl(url);
        }
        String path = VfsUtilCore.urlToPath((String)url);
        return new File(FileUtils.toSystemDependentPath((String)path));
    }

    private void addRemainingModelsIfNecessary() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myExcludedModules.getProject());
        for (Module module : moduleManager.getModules()) {
            if (this.myExcludedModules.contains(module)) continue;
            this.addModuleIfNecessary(module);
        }
    }

    private void addModuleIfNecessary(@NotNull Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            IdeBaseArtifact includeArtifact;
            IdeVariant variant = androidModel.getSelectedVariant();
            IdeJavaArtifact unitTestArtifact = variant.getUnitTestArtifact();
            IdeAndroidArtifact androidTestArtifact = variant.getAndroidTestArtifact();
            IdeBaseArtifact excludeArtifact = this.myAndroidTest ? unitTestArtifact : androidTestArtifact;
            IdeBaseArtifact ideBaseArtifact = includeArtifact = this.myAndroidTest ? androidTestArtifact : unitTestArtifact;
            if (excludeArtifact != null) {
                ExcludedRoots.processFolders(excludeArtifact, androidModel, this.myExcludedRoots::add);
            }
            if (includeArtifact != null) {
                ExcludedRoots.processFolders(includeArtifact, androidModel, this.myExcludedRoots::remove);
            }
        }
    }

    private static void processFolders(@NotNull IdeBaseArtifact artifact, @NotNull AndroidModuleModel androidModel, @NotNull Consumer<File> action) {
        action.accept(artifact.getClassesFolder());
        for (File file : artifact.getGeneratedSourceFolders()) {
            action.accept(file);
        }
        String artifactName = artifact.getName();
        List<SourceProvider> testSourceProviders = androidModel.getTestSourceProviders(artifactName);
        for (SourceProvider sourceProvider : testSourceProviders) {
            for (File file : IdeaSourceProvider.getAllSourceFolders(sourceProvider)) {
                action.accept(file);
            }
        }
    }

    private void addLibraryPaths(@NotNull DependencySet dependencies2) {
        for (LibraryDependency dependency : dependencies2.onLibraries()) {
            Collections.addAll(this.myExcludedRoots, dependency.getPaths(LibraryDependency.PathType.BINARY));
        }
    }

    void removeLibraryPaths(@NotNull DependencySet dependencies2) {
        for (LibraryDependency dependency : dependencies2.onLibraries()) {
            for (File path : dependency.getPaths(LibraryDependency.PathType.BINARY)) {
                this.myExcludedRoots.remove(path);
            }
        }
        Project project = this.myModule.getProject();
        for (ModuleDependency dependency : dependencies2.onModules()) {
            Module module = dependency.getModule(project);
            if (module == null) continue;
            this.addLibraryPaths(module);
        }
    }

    private void addLibraryPaths(@NotNull Module module) {
        AndroidModuleModel model = AndroidModuleModel.get(module);
        if (model != null) {
            IdeBaseArtifact include;
            IdeVariant variant = model.getSelectedVariant();
            IdeBaseArtifact exclude = this.myAndroidTest ? variant.getUnitTestArtifact() : variant.getAndroidTestArtifact();
            IdeBaseArtifact ideBaseArtifact = include = this.myAndroidTest ? variant.getAndroidTestArtifact() : variant.getUnitTestArtifact();
            if (exclude != null) {
                this.addLibraryPaths(exclude);
            }
            if (include != null) {
                this.removeLibraryPaths(include);
            }
        }
    }

    private void addLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        IdeDependencies dependencies2 = artifact.getDependencies();
        dependencies2.forEachLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                for (File file : library.getLocalJars()) {
                    if (this.isAlreadyIncluded(file)) continue;
                    this.myExcludedRoots.add(file);
                }
            }
        });
        dependencies2.forEachJavaLibrary(library -> {
            File jarFile;
            if (StringUtil.isEmpty((String)library.getProject()) && !this.isAlreadyIncluded(jarFile = library.getJarFile())) {
                this.myExcludedRoots.add(jarFile);
            }
        });
    }

    private boolean isAlreadyIncluded(@NotNull File file) {
        return this.myIncludedRootNames.contains(file.getName());
    }

    private void removeLibraryPaths(@NotNull IdeBaseArtifact artifact) {
        IdeDependencies dependencies2 = artifact.getDependencies();
        dependencies2.forEachLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                for (File file : library.getLocalJars()) {
                    this.myExcludedRoots.remove(file);
                }
            }
        });
        dependencies2.forEachJavaLibrary(library -> {
            if (StringUtil.isEmpty((String)library.getProject())) {
                this.myExcludedRoots.remove(library.getJarFile());
            }
        });
    }

    @NotNull
    public Set<File> get() {
        return this.myExcludedRoots;
    }
}

