/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRootSearchScope
extends GlobalSearchScope {
    @NotNull
    private final TObjectIntHashMap<File> myDirRootPaths = new TObjectIntHashMap();
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;

    public FileRootSearchScope(@NotNull Project project, @NotNull Collection<File> rootDirPaths) {
        super(project);
        int i = 1;
        for (File root : rootDirPaths) {
            this.myDirRootPaths.put((Object)root, i++);
        }
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
    }

    public boolean accept(@NotNull File file) {
        while (!file.exists()) {
            if (this.myDirRootPaths.containsKey((Object)file)) {
                return true;
            }
            file = file.getParentFile();
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
        if (virtualFile != null) {
            return this.accept(virtualFile);
        }
        return false;
    }

    public boolean contains(@NotNull VirtualFile file) {
        VirtualFile sourceRootForFile;
        File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        if (this.myDirRootPaths.contains((Object)path)) {
            return true;
        }
        if (this.myProjectFileIndex.isInContent(file) && (sourceRootForFile = this.myProjectFileIndex.getSourceRootForFile(file)) != null) {
            path = VfsUtilCore.virtualToIoFile((VirtualFile)sourceRootForFile);
            return this.myDirRootPaths.contains((Object)path);
        }
        VirtualFile classRootForFile = this.myProjectFileIndex.getClassRootForFile(file);
        if (classRootForFile != null) {
            path = VfsUtilCore.virtualToIoFile((VirtualFile)classRootForFile);
            return this.myDirRootPaths.contains((Object)path);
        }
        return false;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile r2;
        VirtualFile r1 = this.getFileRoot(file1);
        if (Comparing.equal((Object)r1, (Object)(r2 = this.getFileRoot(file2)))) {
            return 0;
        }
        if (r1 == null) {
            return -1;
        }
        if (r2 == null) {
            return 1;
        }
        int i1 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r1));
        int i2 = this.myDirRootPaths.get((Object)VfsUtilCore.virtualToIoFile((VirtualFile)r2));
        if (i1 == 0 && i2 == 0) {
            return 0;
        }
        if (i1 > 0 && i2 > 0) {
            return i2 - i1;
        }
        return i1 > 0 ? 1 : -1;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return true;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file) {
        if (this.myProjectFileIndex.isInContent(file)) {
            return this.myProjectFileIndex.getSourceRootForFile(file);
        }
        return this.myProjectFileIndex.getClassRootForFile(file);
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope instanceof FileRootSearchScope) {
            return this.merge((FileRootSearchScope)scope);
        }
        return super.uniteWith(scope);
    }

    @NotNull
    protected FileRootSearchScope merge(@NotNull FileRootSearchScope scope) {
        return this.calculate(scope, true);
    }

    @NotNull
    protected FileRootSearchScope exclude(@NotNull FileRootSearchScope scope) {
        return this.calculate(scope, false);
    }

    @NotNull
    private FileRootSearchScope calculate(@NotNull FileRootSearchScope scope, boolean merge) {
        HashSet roots = Sets.newHashSet();
        this.myDirRootPaths.forEach(file -> {
            roots.add(file);
            return true;
        });
        scope.myDirRootPaths.forEach(file -> {
            if (merge) {
                roots.add(file);
            } else {
                roots.remove(file);
            }
            return true;
        });
        Project project = this.getProject();
        assert (project != null);
        return new FileRootSearchScope(project, roots);
    }
}

