/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.AbstractPackageSet;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.ui.Colored;
import java.util.List;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestArtifactCustomScopeProvider
extends CustomScopesProviderEx {
    private static List<NamedScope> SCOPES = ImmutableList.of((Object)((Object)new UnitTestsScope()), (Object)((Object)new AndroidTestsScope()));

    @NotNull
    public List<NamedScope> getCustomScopes() {
        return SCOPES;
    }

    public boolean isVetoed(@NotNull NamedScope scope, @NotNull CustomScopesProviderEx.ScopePlace place) {
        return scope instanceof AndroidTestsScope && place == CustomScopesProviderEx.ScopePlace.ACTION;
    }

    @Nullable
    private static TestArtifactSearchScopes getTestArtifactSearchScopes(@Nullable VirtualFile file, @NotNull Project project) {
        if (file == null) {
            return null;
        }
        Module module = FileIndexFacade.getInstance((Project)project).getModuleForFile(file);
        if (module == null) {
            return null;
        }
        return TestArtifactSearchScopes.get(module);
    }

    @Colored(color="e7fadb", darkVariant="2A3B2C")
    public static class UnitTestsScope
    extends NamedScope {
        public static final String NAME = "Local Unit Tests";

        public UnitTestsScope() {
            super(NAME, (PackageSet)new AbstractPackageSet("test:*..*"){

                public boolean contains(@Nullable VirtualFile file, @NotNull NamedScopesHolder holder) {
                    return this.contains(file, holder.getProject(), holder);
                }

                public boolean contains(@Nullable VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    TestArtifactSearchScopes scopes = TestArtifactCustomScopeProvider.getTestArtifactSearchScopes(file, project);
                    if (scopes != null) {
                        return scopes.isUnitTestSource(file);
                    }
                    return file != null && TestSourcesFilter.isTestSources((VirtualFile)file, (Project)project);
                }
            });
        }
    }

    @Colored(color="ffffe4", darkVariant="494539")
    public static class AndroidTestsScope
    extends NamedScope {
        public static final String NAME = AndroidBundle.message("android.test.run.configuration.type.name", new Object[0]);

        public AndroidTestsScope() {
            super(NAME, (PackageSet)new AbstractPackageSet("test:*..*"){

                public boolean contains(@Nullable VirtualFile file, @NotNull NamedScopesHolder holder) {
                    return this.contains(file, holder.getProject(), holder);
                }

                public boolean contains(@Nullable VirtualFile file, @NotNull Project project, @Nullable NamedScopesHolder holder) {
                    TestArtifactSearchScopes scopes = TestArtifactCustomScopeProvider.getTestArtifactSearchScopes(file, project);
                    return scopes != null && scopes.isAndroidTestSource(file);
                }
            });
        }
    }
}

