/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.testartifacts.scopes;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependenciesExtractor;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.android.tools.idea.testartifacts.scopes.ExcludedModules;
import com.android.tools.idea.testartifacts.scopes.ExcludedRoots;
import com.android.tools.idea.testartifacts.scopes.FileRootSearchScope;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestArtifactSearchScopes
implements Disposable {
    private static final Key<TestArtifactSearchScopes> SEARCH_SCOPES_KEY = Key.create((String)"TEST_ARTIFACT_SEARCH_SCOPES");
    @NotNull
    private final Module myModule;
    private FileRootSearchScope myAndroidTestSourceScope;
    private FileRootSearchScope myUnitTestSourceScope;
    private FileRootSearchScope myAndroidTestExcludeScope;
    private FileRootSearchScope myUnitTestExcludeScope;
    private FileRootSearchScope myAndroidTestDependencyExcludeScope;
    private FileRootSearchScope mySharedTestsExcludeScope;
    private FileRootSearchScope myUnitTestDependencyExcludeScope;
    private final Object myLock = new Object();
    private DependencySet myMainDependencies;
    private DependencySet myUnitTestDependencies;
    private DependencySet myAndroidTestDependencies;
    private boolean myAlreadyResolved;

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull VirtualFile file, @NotNull Project project) {
        if (GradleSyncState.getInstance(project).lastSyncFailed()) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        Module module = projectFileIndex.getModuleForFile(file);
        return module != null ? TestArtifactSearchScopes.get(module) : null;
    }

    @Nullable
    public static TestArtifactSearchScopes get(@NotNull Module module) {
        return (TestArtifactSearchScopes)module.getUserData(SEARCH_SCOPES_KEY);
    }

    public static void initializeScope(@NotNull Module module) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        TestArtifactSearchScopes scopes = androidModel != null ? new TestArtifactSearchScopes(module) : null;
        module.putUserData(SEARCH_SCOPES_KEY, (Object)scopes);
    }

    private TestArtifactSearchScopes(@NotNull Module module) {
        this.myModule = module;
        Disposer.register((Disposable)module, (Disposable)this);
        module.putUserData(SEARCH_SCOPES_KEY, (Object)this);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    public boolean isAndroidTestSource(@NotNull VirtualFile file) {
        return this.getAndroidTestSourceScope().accept(file);
    }

    public boolean isUnitTestSource(@NotNull VirtualFile file) {
        return this.getUnitTestSourceScope().accept(file);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestSourceScope() {
        if (this.myAndroidTestSourceScope == null) {
            this.myAndroidTestSourceScope = this.getSourceScope("_android_test_");
        }
        return this.myAndroidTestSourceScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestSourceScope() {
        if (this.myUnitTestSourceScope == null) {
            this.myUnitTestSourceScope = this.getSourceScope("_unit_test_");
        }
        return this.myUnitTestSourceScope;
    }

    @NotNull
    private FileRootSearchScope getSourceScope(@NotNull String artifactName) {
        Set<File> roots;
        block4: {
            roots = Collections.emptySet();
            AndroidModuleModel androidModel = this.getAndroidModel();
            if (androidModel == null) break block4;
            roots = new HashSet();
            if (artifactName.equals("_android_test_") && androidModel.getAndroidProject().getProjectType() == 2) {
                for (SourceProvider sourceProvider : androidModel.getActiveSourceProviders()) {
                    roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
                }
            } else {
                for (SourceProvider sourceProvider : androidModel.getTestSourceProviders(artifactName)) {
                    roots.addAll(IdeaSourceProvider.getAllSourceFolders(sourceProvider));
                }
            }
        }
        return new FileRootSearchScope(this.myModule.getProject(), roots);
    }

    @NotNull
    public FileRootSearchScope getAndroidTestExcludeScope() {
        if (this.myAndroidTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getUnitTestSourceScope().exclude(this.getAndroidTestSourceScope());
            this.myAndroidTestExcludeScope = exclude.merge(this.getAndroidTestDependencyExcludeScope());
        }
        return this.myAndroidTestExcludeScope;
    }

    @NotNull
    public FileRootSearchScope getUnitTestExcludeScope() {
        if (this.myUnitTestExcludeScope == null) {
            FileRootSearchScope exclude = this.getAndroidTestSourceScope().exclude(this.getUnitTestSourceScope());
            this.myUnitTestExcludeScope = exclude.merge(this.getUnitTestDependencyExcludeScope());
        }
        return this.myUnitTestExcludeScope;
    }

    @NotNull
    public FileRootSearchScope getSharedTestsExcludeScope() {
        if (this.mySharedTestsExcludeScope == null) {
            this.mySharedTestsExcludeScope = this.getAndroidTestDependencyExcludeScope().merge(this.getUnitTestDependencyExcludeScope());
        }
        return this.mySharedTestsExcludeScope;
    }

    @NotNull
    private FileRootSearchScope getAndroidTestDependencyExcludeScope() {
        if (this.myAndroidTestDependencyExcludeScope == null) {
            this.myAndroidTestDependencyExcludeScope = this.getExcludedDependenciesScope("_android_test_");
        }
        return this.myAndroidTestDependencyExcludeScope;
    }

    @NotNull
    private FileRootSearchScope getUnitTestDependencyExcludeScope() {
        if (this.myUnitTestDependencyExcludeScope == null) {
            this.myUnitTestDependencyExcludeScope = this.getExcludedDependenciesScope("_unit_test_");
        }
        return this.myUnitTestDependencyExcludeScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private FileRootSearchScope getExcludedDependenciesScope(@NotNull String artifactName) {
        Set<File> excluded;
        if (this.getAndroidModel() == null) {
            return new FileRootSearchScope(this.myModule.getProject(), Collections.emptyList());
        }
        this.resolveDependencies();
        boolean isAndroidTest = "_android_test_".equals(artifactName);
        Object object = this.myLock;
        synchronized (object) {
            DependencySet dependenciesToInclude = isAndroidTest ? this.myAndroidTestDependencies : this.myUnitTestDependencies;
            DependencySet dependenciesToExclude = isAndroidTest ? this.myUnitTestDependencies : this.myAndroidTestDependencies;
            ExcludedModules excludedModules = new ExcludedModules(this.myModule);
            excludedModules.add(dependenciesToExclude);
            excludedModules.remove(dependenciesToInclude);
            excludedModules.remove(this.myMainDependencies);
            ExcludedRoots excludedRoots = new ExcludedRoots(this.myModule, excludedModules, dependenciesToExclude, dependenciesToInclude, isAndroidTest);
            excludedRoots.removeLibraryPaths(this.myMainDependencies);
            excluded = excludedRoots.get();
        }
        return new FileRootSearchScope(this.myModule.getProject(), excluded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void resolveDependencies() {
        AndroidModuleModel androidModel = this.getAndroidModel();
        Object object = this.myLock;
        synchronized (object) {
            if (androidModel == null || this.myAlreadyResolved) {
                return;
            }
            this.myAlreadyResolved = true;
            this.extractMainDependencies(androidModel);
            this.extractAndroidTestDependencies(androidModel);
            this.extractUnitTestDependencies(androidModel);
            this.mergeSubmoduleDependencies(this.myMainDependencies, this.myMainDependencies, null, null);
            this.mergeSubmoduleDependencies(this.myAndroidTestDependencies, this.myAndroidTestDependencies, this.myAndroidTestDependencies, null);
            this.mergeSubmoduleDependencies(this.myUnitTestDependencies, this.myUnitTestDependencies, null, this.myUnitTestDependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractMainDependencies(@NotNull AndroidModuleModel androidModel) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myMainDependencies == null) {
                this.myMainDependencies = TestArtifactSearchScopes.extractDependencies(DependencyScope.COMPILE, androidModel.getMainArtifact());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractUnitTestDependencies(@NotNull AndroidModuleModel androidModel) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myUnitTestDependencies == null) {
                IdeJavaArtifact artifact = androidModel.getSelectedVariant().getUnitTestArtifact();
                this.myUnitTestDependencies = TestArtifactSearchScopes.extractTestDependencies(artifact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractAndroidTestDependencies(@NotNull AndroidModuleModel androidModel) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myAndroidTestDependencies == null) {
                IdeAndroidArtifact artifact = androidModel.getSelectedVariant().getAndroidTestArtifact();
                this.myAndroidTestDependencies = TestArtifactSearchScopes.extractTestDependencies(artifact);
            }
        }
    }

    @NotNull
    private static DependencySet extractTestDependencies(@Nullable IdeBaseArtifact artifact) {
        return TestArtifactSearchScopes.extractDependencies(DependencyScope.TEST, artifact);
    }

    @NotNull
    private static DependencySet extractDependencies(@NotNull DependencyScope scope, @Nullable IdeBaseArtifact artifact) {
        return artifact != null ? DependenciesExtractor.getInstance().extractFrom(artifact, scope) : DependencySet.EMPTY;
    }

    @Nullable
    private AndroidModuleModel getAndroidModel() {
        return this.myModule.isDisposed() ? null : AndroidModuleModel.get(this.myModule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeSubmoduleDependencies(@NotNull DependencySet original, @Nullable DependencySet toMergeMain, @Nullable DependencySet toMergeAndroid, @Nullable DependencySet toMergeUnit) {
        HashSet<ModuleDependency> moduleDependencies = new HashSet<ModuleDependency>((Collection<ModuleDependency>)original.onModules());
        Object object = this.myLock;
        synchronized (object) {
            for (ModuleDependency moduleDependency : moduleDependencies) {
                TestArtifactSearchScopes moduleScope;
                Module module = moduleDependency.getModule(this.myModule.getProject());
                if (module == null || (moduleScope = TestArtifactSearchScopes.get(module)) == null) continue;
                moduleScope.resolveDependencies();
                if (toMergeMain != null) {
                    toMergeMain.addAll(moduleScope.myMainDependencies);
                }
                if (toMergeAndroid != null) {
                    toMergeAndroid.addAll(moduleScope.myAndroidTestDependencies);
                }
                if (toMergeUnit == null) continue;
                toMergeUnit.addAll(moduleScope.myUnitTestDependencies);
            }
        }
    }

    public void dispose() {
        this.myModule.putUserData(SEARCH_SCOPES_KEY, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getMainDependencies() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myMainDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getUnitTestDependencies() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myUnitTestDependencies;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    DependencySet getAndroidTestDependencies() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myAndroidTestDependencies;
        }
    }

    public String toString() {
        return this.myModule.getName();
    }
}

