/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncIcon
implements Icon {
    @NotNull
    private Icon myIcon;
    private final int myW;
    private final int myH;

    public AsyncIcon(@NotNull ListenableFuture<? extends Icon> futureIcon, @NotNull Icon placeholderIcon, final @Nullable Runnable onIconLoad) {
        this.myIcon = placeholderIcon;
        this.myW = placeholderIcon.getIconWidth();
        this.myH = placeholderIcon.getIconHeight();
        Futures.addCallback(futureIcon, (FutureCallback)new FutureCallback<Icon>(){

            public void onSuccess(@Nullable Icon result) {
                if (result != null) {
                    AsyncIcon.this.myIcon = result;
                }
                if (onIconLoad != null) {
                    onIconLoad.run();
                }
            }

            public void onFailure(@NotNull Throwable e) {
                Logger.getInstance(AsyncIcon.class).warn("Unable to load AsyncIcon", e);
            }
        });
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.myIcon;
        assert (icon.getIconWidth() == this.myW && icon.getIconHeight() == this.myH);
        icon.paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.myW;
    }

    @Override
    public int getIconHeight() {
        return this.myH;
    }
}

