/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.tools.idea.ui.resourcechooser.ResourceChooserImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceChooserColorIcon
implements Icon {
    @NotNull
    private final Color myColor;
    private final int myWidth;
    private final int myHeight;
    @Nullable
    private final Paint myCheckerPaint;

    public ResourceChooserColorIcon(int size, @NotNull Color color, int checkerboardSize) {
        this(size, size, color, checkerboardSize);
    }

    public ResourceChooserColorIcon(int width, int height, @NotNull Color color, int checkerboardSize) {
        this.myColor = color;
        this.myWidth = width;
        this.myHeight = height;
        this.myCheckerPaint = checkerboardSize > 0 ? new ResourceChooserImageIcon.CheckerboardPaint(checkerboardSize) : null;
    }

    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        if (this.myColor.getAlpha() != 255 && this.myCheckerPaint != null) {
            ((Graphics2D)g).setPaint(this.myCheckerPaint);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        }
        g.setColor(this.myColor);
        g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
    }

    @Override
    public int getIconWidth() {
        return this.myWidth;
    }

    @Override
    public int getIconHeight() {
        return this.myHeight;
    }
}

