/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import javax.swing.Icon;
import sun.awt.image.IntegerComponentRaster;

public class ResourceChooserImageIcon
implements Icon {
    private final int mySize;
    private final Image myImage;
    private final Paint myCheckerPaint;
    private boolean myInterpolate;

    public ResourceChooserImageIcon(int size, Image image, int checkerboardSize, boolean interpolate) {
        this.mySize = size;
        this.myImage = image;
        this.myCheckerPaint = checkerboardSize > 0 ? new CheckerboardPaint(checkerboardSize) : null;
        this.myInterpolate = interpolate;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        double scale = Math.min((double)this.getIconHeight() / (double)this.myImage.getHeight(c), (double)this.getIconWidth() / (double)this.myImage.getWidth(c));
        int dx = (int)((double)this.getIconWidth() - (double)this.myImage.getWidth(c) * scale) / 2;
        int dy = (int)((double)this.getIconHeight() - (double)this.myImage.getHeight(c) * scale) / 2;
        if (this.myCheckerPaint != null) {
            ((Graphics2D)g).setPaint(this.myCheckerPaint);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
        }
        if (this.myInterpolate) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        g.drawImage(this.myImage, x + dx, y + dy, (int)((double)this.myImage.getWidth(c) * scale), (int)((double)this.myImage.getHeight(c) * scale), null);
    }

    @Override
    public int getIconWidth() {
        return this.mySize;
    }

    @Override
    public int getIconHeight() {
        return this.mySize;
    }

    public static class CheckerboardPaint
    implements Paint,
    PaintContext {
        private final int myCheckerSize;
        private final int myDoubleCheckerSize;
        private static final int LIGHT_COLOR = -1;
        private static final int DARK_COLOR = -4144960;
        private WritableRaster cachedRaster;
        private int[] cachedEvenRow = new int[0];
        private int[] cachedOddRow = new int[0];

        public CheckerboardPaint(int size) {
            this.myCheckerSize = size;
            this.myDoubleCheckerSize = 2 * this.myCheckerSize;
        }

        @Override
        public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
            return this;
        }

        @Override
        public void dispose() {
            this.cachedRaster = null;
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int x, int y, int w, int h) {
            WritableRaster raster = this.cachedRaster;
            if (raster == null || w > raster.getWidth() || h > raster.getHeight()) {
                this.cachedRaster = raster = this.getColorModel().createCompatibleWritableRaster(w, h);
            }
            w = raster.getWidth();
            h = raster.getHeight();
            int xOffset = x % this.myDoubleCheckerSize;
            int yOffset = y % this.myDoubleCheckerSize;
            int[] evenRow = this.cachedEvenRow;
            int[] oddRow = this.cachedOddRow;
            if (evenRow.length < xOffset + w || oddRow.length < xOffset + w) {
                evenRow = new int[this.myDoubleCheckerSize * ((xOffset + w + this.myDoubleCheckerSize - 1) / this.myDoubleCheckerSize)];
                oddRow = new int[evenRow.length];
                for (int i = 0; i < evenRow.length; i += this.myDoubleCheckerSize) {
                    Arrays.fill(evenRow, i, i + this.myCheckerSize, -1);
                    Arrays.fill(evenRow, i + this.myCheckerSize, i + this.myDoubleCheckerSize, -4144960);
                    Arrays.fill(oddRow, i, i + this.myCheckerSize, -4144960);
                    Arrays.fill(oddRow, i + this.myCheckerSize, i + this.myDoubleCheckerSize, -1);
                }
            }
            int[] pixels = ((IntegerComponentRaster)raster).getDataStorage();
            int[][] rows = new int[][]{evenRow, oddRow};
            int curRowPointer = yOffset < this.myCheckerSize ? 0 : 1;
            int[] curRow = rows[curRowPointer];
            int i = 0;
            int done = 0;
            int tileY = yOffset % this.myCheckerSize;
            while (i < h) {
                if (tileY >= this.myCheckerSize) {
                    tileY = 0;
                    curRowPointer = curRowPointer + 1 & 1;
                    curRow = rows[curRowPointer];
                }
                System.arraycopy(curRow, xOffset, pixels, done, w);
                ++i;
                ++tileY;
                done += w;
            }
            return raster;
        }

        @Override
        public int getTransparency() {
            return 1;
        }
    }
}

