/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HideableDecorator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.jetbrains.android.actions.CreateXmlResourcePanel;
import org.jetbrains.android.actions.NewResourceCreationHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceEditorTab {
    private JPanel myFullPanel;
    private JPanel myExpertPlaceholder;
    private JPanel myExpertPanel;
    private JPanel myEditorPanel;
    private HideableDecorator myExpertDecorator;
    @NotNull
    private CreateXmlResourcePanel myLocationSettings;
    @NotNull
    private ChooseResourceDialog.ResourceNameVisibility myResourceNameVisibility;
    @NotNull
    private final String myTabTitle;

    public ResourceEditorTab(@NotNull Module module, @NotNull String tabTitle, @NotNull Component centerPanel, @NotNull ChooseResourceDialog.ResourceNameVisibility resourceNameVisibility, @NotNull ResourceFolderType folderType, boolean changeFileNameVisible, @NotNull ResourceType resourceType) {
        this.myResourceNameVisibility = resourceNameVisibility;
        this.myTabTitle = tabTitle;
        this.$$$setupUI$$$();
        this.myExpertDecorator = new HideableDecorator(this.myExpertPlaceholder, "Device Configuration", true){

            private void pack() {
                ApplicationManager.getApplication().invokeLater(() -> SwingUtilities.getWindowAncestor(ResourceEditorTab.this.myExpertPlaceholder).pack(), ModalityState.any());
            }

            protected void on() {
                super.on();
                this.pack();
            }

            protected void off() {
                super.off();
                this.pack();
            }
        };
        this.myExpertDecorator.setContentComponent((JComponent)this.myExpertPanel);
        this.myEditorPanel.add(centerPanel);
        this.myFullPanel.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        NewResourceCreationHandler newResourceHandler = NewResourceCreationHandler.getInstance(module.getProject());
        Function<Module, IdeResourceNameValidator> nameValidatorFactory = selectedModule -> IdeResourceNameValidator.forResourceName(resourceType, AppResourceRepository.getOrCreateInstance(selectedModule));
        this.myLocationSettings = newResourceHandler.createNewResourceValuePanel(module, resourceType, folderType, "", "", false, false, changeFileNameVisible, null, null, nameValidatorFactory);
        this.myExpertPanel.add(this.myLocationSettings.getPanel());
    }

    @NotNull
    public JPanel getFullPanel() {
        return this.myFullPanel;
    }

    public void setLocationSettingsOpen(boolean open) {
        this.myExpertDecorator.setOn(open);
    }

    @NotNull
    public CreateXmlResourcePanel getLocationSettings() {
        return this.myLocationSettings;
    }

    @NotNull
    public ChooseResourceDialog.ResourceNameVisibility getResourceNameVisibility() {
        return this.myResourceNameVisibility;
    }

    @Nullable
    public ValidationInfo doValidate() {
        return this.getLocationSettings().doValidate();
    }

    @NotNull
    public abstract String doSave();

    @NotNull
    public Module getSelectedModule() {
        Module module = this.getLocationSettings().getModule();
        assert (module != null);
        return module;
    }

    @Nullable
    public VirtualFile getResourceDirectory() {
        return this.getLocationSettings().getResourceDirectory();
    }

    @NotNull
    public IdeResourceNameValidator getValidator() {
        return this.getLocationSettings().getResourceNameValidator();
    }

    @NotNull
    public String getTabTitle() {
        return this.myTabTitle;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myFullPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(0, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        this.myEditorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 5), null));
        this.myExpertPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 0, null, null, null));
        this.myExpertPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myFullPanel;
    }
}

